% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_create_bot_locale}
\alias{lexmodelsv2_create_bot_locale}
\title{Creates a locale in the bot}
\usage{
lexmodelsv2_create_bot_locale(
  botId,
  botVersion,
  localeId,
  description = NULL,
  nluIntentConfidenceThreshold,
  voiceSettings = NULL
)
}
\arguments{
\item{botId}{[required] The identifier of the bot to create the locale for.}

\item{botVersion}{[required] The version of the bot to create the locale for. This can only be the
draft version of the bot.}

\item{localeId}{[required] The identifier of the language and locale that the bot will be used in.
The string must match one of the supported locales. All of the intents,
slot types, and slots used in the bot must have the same locale. For
more information, see \href{https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html}{Supported languages}.}

\item{description}{A description of the bot locale. Use this to help identify the bot
locale in lists.}

\item{nluIntentConfidenceThreshold}{[required] Determines the threshold where Amazon Lex will insert the
\code{AMAZON.FallbackIntent}, \code{AMAZON.KendraSearchIntent}, or both when
returning alternative intents. \code{AMAZON.FallbackIntent} and
\code{AMAZON.KendraSearchIntent} are only inserted if they are configured for
the bot.

For example, suppose a bot is configured with the confidence threshold
of 0.80 and the \code{AMAZON.FallbackIntent}. Amazon Lex returns three
alternative intents with the following confidence scores: IntentA
(0.70), IntentB (0.60), IntentC (0.50). The response from the
\code{RecognizeText} operation would be:
\itemize{
\item AMAZON.FallbackIntent
\item IntentA
\item IntentB
\item IntentC
}}

\item{voiceSettings}{The Amazon Polly voice ID that Amazon Lex uses for voice interaction
with the user.}
}
\description{
Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.

See \url{https://paws-r.github.io/docs/lexmodelsv2/create_bot_locale.html} for full documentation.
}
\keyword{internal}
