% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_put_lexicon}
\alias{polly_put_lexicon}
\title{Stores a pronunciation lexicon in an Amazon Web Services Region}
\usage{
polly_put_lexicon(Name, Content)
}
\arguments{
\item{Name}{[required] Name of the lexicon. The name must follow the regular express format
[0-9A-Za-z]\{1,20\}. That is, the name is a case-sensitive
alphanumeric string up to 20 characters long.}

\item{Content}{[required] Content of the PLS lexicon as string data.}
}
\description{
Stores a pronunciation lexicon in an Amazon Web Services Region. If a lexicon with the same name already exists in the region, it is overwritten by the new lexicon. Lexicon operations have eventual consistency, therefore, it might take some time before the lexicon is available to the SynthesizeSpeech operation.

See \url{https://paws-r.github.io/docs/polly/put_lexicon.html} for full documentation.
}
\keyword{internal}
