% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_context}
\alias{sagemaker_create_context}
\title{Creates a context}
\usage{
sagemaker_create_context(
  ContextName,
  Source,
  ContextType,
  Description = NULL,
  Properties = NULL,
  Tags = NULL
)
}
\arguments{
\item{ContextName}{[required] The name of the context. Must be unique to your account in an Amazon Web
Services Region.}

\item{Source}{[required] The source type, ID, and URI.}

\item{ContextType}{[required] The context type.}

\item{Description}{The description of the context.}

\item{Properties}{A list of properties to add to the context.}

\item{Tags}{A list of tags to apply to the context.}
}
\description{
Creates a \emph{context}. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html}{Amazon SageMaker ML Lineage Tracking}.

See \url{https://paws-r.github.io/docs/sagemaker/create_context.html} for full documentation.
}
\keyword{internal}
