% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_image_version}
\alias{sagemaker_create_image_version}
\title{Creates a version of the SageMaker image specified by ImageName}
\usage{
sagemaker_create_image_version(BaseImage, ClientToken, ImageName)
}
\arguments{
\item{BaseImage}{[required] The registry path of the container image to use as the starting point
for this version. The path is an Amazon Elastic Container Registry (ECR)
URI in the following format:

\verb{<acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@digest]>}}

\item{ClientToken}{[required] A unique ID. If not specified, the Amazon Web Services CLI and Amazon
Web Services SDKs, such as the SDK for Python (Boto3), add a unique
value to the call.}

\item{ImageName}{[required] The \code{ImageName} of the \code{Image} to create a version of.}
}
\description{
Creates a version of the SageMaker image specified by \code{ImageName}. The version represents the Amazon Elastic Container Registry (ECR) container image specified by \code{BaseImage}.

See \url{https://paws-r.github.io/docs/sagemaker/create_image_version.html} for full documentation.
}
\keyword{internal}
