% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalizeevents_operations.R
\name{personalizeevents_put_events}
\alias{personalizeevents_put_events}
\title{Records user interaction event data}
\usage{
personalizeevents_put_events(trackingId, userId = NULL, sessionId, eventList)
}
\arguments{
\item{trackingId}{[required] The tracking ID for the event. The ID is generated by a call to the
\href{https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html}{CreateEventTracker}
API.}

\item{userId}{The user associated with the event.}

\item{sessionId}{[required] The session ID associated with the user's visit. Your application
generates the sessionId when a user first visits your website or uses
your application. Amazon Personalize uses the sessionId to associate
events with the user before they log in. For more information, see
\href{https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html}{Recording Events}.}

\item{eventList}{[required] A list of event data from the session.}
}
\description{
Records user interaction event data. For more information see \href{https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html}{Recording Events}.

See \url{https://www.paws-r-sdk.com/docs/personalizeevents_put_events/} for full documentation.
}
\keyword{internal}
