% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_domain}
\alias{sagemaker_create_domain}
\title{Creates a Domain used by Amazon SageMaker Studio}
\usage{
sagemaker_create_domain(
  DomainName,
  AuthMode,
  DefaultUserSettings,
  SubnetIds,
  VpcId,
  Tags = NULL,
  AppNetworkAccessType = NULL,
  HomeEfsFileSystemKmsKeyId = NULL,
  KmsKeyId = NULL,
  AppSecurityGroupManagement = NULL,
  DomainSettings = NULL,
  DefaultSpaceSettings = NULL
)
}
\arguments{
\item{DomainName}{[required] A name for the domain.}

\item{AuthMode}{[required] The mode of authentication that members use to access the domain.}

\item{DefaultUserSettings}{[required] The default settings to use to create a user profile when \code{UserSettings}
isn't specified in the call to the
\code{\link[=sagemaker_create_user_profile]{create_user_profile}} API.

\code{SecurityGroups} is aggregated when specified in both calls. For all
other settings in \code{UserSettings}, the values specified in
\code{\link[=sagemaker_create_user_profile]{create_user_profile}} take precedence
over those specified in \code{\link[=sagemaker_create_domain]{create_domain}}.}

\item{SubnetIds}{[required] The VPC subnets that Studio uses for communication.}

\item{VpcId}{[required] The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for
communication.}

\item{Tags}{Tags to associated with the Domain. Each tag consists of a key and an
optional value. Tag keys must be unique per resource. Tags are
searchable using the \code{\link[=sagemaker_search]{search}} API.

Tags that you specify for the Domain are also added to all Apps that the
Domain launches.}

\item{AppNetworkAccessType}{Specifies the VPC used for non-EFS traffic. The default value is
\code{PublicInternetOnly}.
\itemize{
\item \code{PublicInternetOnly} - Non-EFS traffic is through a VPC managed by
Amazon SageMaker, which allows direct internet access
\item \code{VpcOnly} - All Studio traffic is through the specified VPC and
subnets
}}

\item{HomeEfsFileSystemKmsKeyId}{Use \code{KmsKeyId}.}

\item{KmsKeyId}{SageMaker uses Amazon Web Services KMS to encrypt the EFS volume
attached to the domain with an Amazon Web Services managed key by
default. For more control, specify a customer managed key.}

\item{AppSecurityGroupManagement}{The entity that creates and manages the required security groups for
inter-app communication in \code{VPCOnly} mode. Required when
\code{CreateDomain.AppNetworkAccessType} is \code{VPCOnly} and
\code{DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn}
is provided. If setting up the domain for use with RStudio, this value
must be set to \code{Service}.}

\item{DomainSettings}{A collection of \code{Domain} settings.}

\item{DefaultSpaceSettings}{The default settings used to create a space.}
}
\description{
Creates a \code{Domain} used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. Users within a domain can share notebook files and other artifacts with each other.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_domain/} for full documentation.
}
\keyword{internal}
