% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_presigned_domain_url}
\alias{sagemaker_create_presigned_domain_url}
\title{Creates a URL for a specified UserProfile in a Domain}
\usage{
sagemaker_create_presigned_domain_url(
  DomainId,
  UserProfileName,
  SessionExpirationDurationInSeconds = NULL,
  ExpiresInSeconds = NULL,
  SpaceName = NULL
)
}
\arguments{
\item{DomainId}{[required] The domain ID.}

\item{UserProfileName}{[required] The name of the UserProfile to sign-in as.}

\item{SessionExpirationDurationInSeconds}{The session expiration duration in seconds. This value defaults to
43200.}

\item{ExpiresInSeconds}{The number of seconds until the pre-signed URL expires. This value
defaults to 300.}

\item{SpaceName}{The name of the space.}
}
\description{
Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_domain_url/} for full documentation.
}
\keyword{internal}
