% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_model_card_versions}
\alias{sagemaker_list_model_card_versions}
\title{List existing versions of an Amazon SageMaker Model Card}
\usage{
sagemaker_list_model_card_versions(
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  MaxResults = NULL,
  ModelCardName,
  ModelCardStatus = NULL,
  NextToken = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{CreationTimeAfter}{Only list model card versions that were created after the time
specified.}

\item{CreationTimeBefore}{Only list model card versions that were created before the time
specified.}

\item{MaxResults}{The maximum number of model card versions to list.}

\item{ModelCardName}{[required] List model card versions for the model card with the specified name.}

\item{ModelCardStatus}{Only list model card versions with the specified approval status.}

\item{NextToken}{If the response to a previous
\code{\link[=sagemaker_list_model_card_versions]{list_model_card_versions}} request
was truncated, the response includes a \code{NextToken}. To retrieve the next
set of model card versions, use the token in the next request.}

\item{SortBy}{Sort listed model card versions by version. Sorts by version by default.}

\item{SortOrder}{Sort model card versions by ascending or descending order.}
}
\description{
List existing versions of an Amazon SageMaker Model Card.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_model_card_versions/} for full documentation.
}
\keyword{internal}
