% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_synthesize_speech}
\alias{polly_synthesize_speech}
\title{Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes}
\usage{
polly_synthesize_speech(
  Engine = NULL,
  LanguageCode = NULL,
  LexiconNames = NULL,
  OutputFormat,
  SampleRate = NULL,
  SpeechMarkTypes = NULL,
  Text,
  TextType = NULL,
  VoiceId
)
}
\arguments{
\item{Engine}{Specifies the engine (\code{standard}, \code{neural} or \code{long-form}) for Amazon
Polly to use when processing input text for speech synthesis. For
information on Amazon Polly voices and which voices are available for
each engine, see \href{https://docs.aws.amazon.com/polly/latest/dg/voicelist.html}{Available Voices}.

\strong{NTTS-only voices}

When using NTTS-only voices such as Kevin (en-US), this parameter is
required and must be set to \code{neural}. If the engine is not specified, or
is set to \code{standard}, this will result in an error.

\strong{long-form-only voices}

When using long-form-only voices such as Danielle (en-US), this
parameter is required and must be set to \code{long-form}. If the engine is
not specified, or is set to \code{standard} or \code{neural}, this will result in
an error.

Type: String

Valid Values: \code{standard} | \code{neural} | \code{long-form}

Required: Yes

\strong{Standard voices}

For standard voices, this is not required; the engine parameter defaults
to \code{standard}. If the engine is not specified, or is set to \code{standard}
and an NTTS-only voice is selected, this will result in an error.}

\item{LanguageCode}{Optional language code for the Synthesize Speech request. This is only
necessary if using a bilingual voice, such as Aditi, which can be used
for either Indian English (en-IN) or Hindi (hi-IN).

If a bilingual voice is used and no language code is specified, Amazon
Polly uses the default language of the bilingual voice. The default
language for any voice is the one returned by the
\code{\link[=polly_describe_voices]{describe_voices}} operation for the
\code{LanguageCode} parameter. For example, if no language code is specified,
Aditi will use Indian English rather than Hindi.}

\item{LexiconNames}{List of one or more pronunciation lexicon names you want the service to
apply during synthesis. Lexicons are applied only if the language of the
lexicon is the same as the language of the voice. For information about
storing lexicons, see \code{\link[=polly_put_lexicon]{put_lexicon}}.}

\item{OutputFormat}{[required] The format in which the returned output will be encoded. For audio
stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this
will be json.

When pcm is used, the content returned is audio/pcm in a signed 16-bit,
1 channel (mono), little-endian format.}

\item{SampleRate}{The audio frequency specified in Hz.

The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
and "24000". The default value for standard voices is "22050". The
default value for neural voices is "24000". The default value for
long-form voices is "24000".

Valid values for pcm are "8000" and "16000" The default value is
"16000".}

\item{SpeechMarkTypes}{The type of speech marks returned for the input text.}

\item{Text}{[required] Input text to synthesize. If you specify \code{ssml} as the \code{TextType},
follow the SSML format for the input text.}

\item{TextType}{Specifies whether the input text is plain text or SSML. The default
value is plain text. For more information, see \href{https://docs.aws.amazon.com/polly/latest/dg/ssml.html}{Using SSML}.}

\item{VoiceId}{[required] Voice ID to use for the synthesis. You can get a list of available voice
IDs by calling the \code{\link[=polly_describe_voices]{describe_voices}} operation.}
}
\description{
Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML. Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by English voices) unless phoneme mapping is used. For more information, see \href{https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html}{How it Works}.

See \url{https://www.paws-r-sdk.com/docs/polly_synthesize_speech/} for full documentation.
}
\keyword{internal}
