% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voiceid_operations.R
\name{voiceid_create_domain}
\alias{voiceid_create_domain}
\title{Creates a domain that contains all Amazon Connect Voice ID data, such as
speakers, fraudsters, customer audio, and voiceprints}
\usage{
voiceid_create_domain(
  ClientToken = NULL,
  Description = NULL,
  Name,
  ServerSideEncryptionConfiguration,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{Description}{A brief description of this domain.}

\item{Name}{[required] The name of the domain.}

\item{ServerSideEncryptionConfiguration}{[required] The configuration, containing the KMS key identifier, to be used by
Voice ID for the server-side encryption of your data. Refer to \href{https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid}{Amazon Connect Voice ID encryption at rest}
for more details on how the KMS key is used.}

\item{Tags}{A list of tags you want added to the domain.}
}
\description{
Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints. Every domain is created with a default watchlist that fraudsters can be a part of.

See \url{https://www.paws-r-sdk.com/docs/voiceid_create_domain/} for full documentation.
}
\keyword{internal}
