% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_update_bot}
\alias{lexmodelsv2_update_bot}
\title{Updates the configuration of an existing bot}
\usage{
lexmodelsv2_update_bot(
  botId,
  botName,
  description = NULL,
  roleArn,
  dataPrivacy,
  idleSessionTTLInSeconds,
  botType = NULL,
  botMembers = NULL
)
}
\arguments{
\item{botId}{[required] The unique identifier of the bot to update. This identifier is returned
by the \code{\link[=lexmodelsv2_create_bot]{create_bot}} operation.}

\item{botName}{[required] The new name of the bot. The name must be unique in the account that
creates the bot.}

\item{description}{A description of the bot.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that has permissions to
access the bot.}

\item{dataPrivacy}{[required] Provides information on additional privacy protections Amazon Lex should
use with the bot's data.}

\item{idleSessionTTLInSeconds}{[required] The time, in seconds, that Amazon Lex should keep information about a
user's conversation with the bot.

A user interaction remains active for the amount of time specified. If
no conversation occurs during this time, the session expires and Amazon
Lex deletes any data provided before the timeout.

You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.}

\item{botType}{The type of the bot to be updated.}

\item{botMembers}{The list of bot members in the network associated with the update
action.}
}
\description{
Updates the configuration of an existing bot.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot/} for full documentation.
}
\keyword{internal}
