% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_workforce}
\alias{sagemaker_create_workforce}
\title{Use this operation to create a workforce}
\usage{
sagemaker_create_workforce(
  CognitoConfig = NULL,
  OidcConfig = NULL,
  SourceIpConfig = NULL,
  WorkforceName,
  Tags = NULL,
  WorkforceVpcConfig = NULL
)
}
\arguments{
\item{CognitoConfig}{Use this parameter to configure an Amazon Cognito private workforce. A
single Cognito workforce is created using and corresponds to a single
\href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools.html}{Amazon Cognito user pool}.

Do not use \code{OidcConfig} if you specify values for \code{CognitoConfig}.}

\item{OidcConfig}{Use this parameter to configure a private workforce using your own OIDC
Identity Provider.

Do not use \code{CognitoConfig} if you specify values for \code{OidcConfig}.}

\item{SourceIpConfig}{}

\item{WorkforceName}{[required] The name of the private workforce.}

\item{Tags}{An array of key-value pairs that contain metadata to help you categorize
and organize our workforce. Each tag consists of a key and a value, both
of which you define.}

\item{WorkforceVpcConfig}{Use this parameter to configure a workforce using VPC.}
}
\description{
Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_workforce/} for full documentation.
}
\keyword{internal}
