% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_imported_models}
\alias{bedrock_list_imported_models}
\title{Returns a list of models you've imported}
\usage{
bedrock_list_imported_models(
  creationTimeBefore = NULL,
  creationTimeAfter = NULL,
  nameContains = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{creationTimeBefore}{Return imported models that created before the specified time.}

\item{creationTimeAfter}{Return imported models that were created after the specified time.}

\item{nameContains}{Return imported models only if the model name contains these characters.}

\item{maxResults}{The maximum number of results to return in the response. If the total
number of results is greater than this value, use the token returned in
the response in the \code{nextToken} field when making another request to
return the next batch of results.}

\item{nextToken}{If the total number of results is greater than the \code{maxResults} value
provided in the request, enter the token returned in the \code{nextToken}
field in the response in this field to return the next batch of results.}

\item{sortBy}{The field to sort by in the returned list of imported models.}

\item{sortOrder}{Specifies whetehr to sort the results in ascending or descending order.}
}
\description{
Returns a list of models you've imported. You can filter the results to return based on one or more criteria. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html}{Import a customized model} in the \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Amazon Bedrock User Guide}.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_imported_models/} for full documentation.
}
\keyword{internal}
