% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_add_tags}
\alias{cloudtrail_add_tags}
\title{Adds one or more tags to a trail, up to a limit of 50}
\usage{
cloudtrail_add_tags(ResourceId, TagsList)
}
\arguments{
\item{ResourceId}{[required] Specifies the ARN of the trail to which one or more tags will be added.
The format of a trail ARN is:

\code{arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail}}

\item{TagsList}{Contains a list of CloudTrail tags, up to a limit of 50}
}
\description{
Adds one or more tags to a trail, up to a limit of 50. Tags must be
unique per trail. Overwrites an existing tag's value when a new value
is specified for an existing tag key. If you specify a key without a
value, the tag will be created with the specified key and a value of
null. You can tag a trail that applies to all regions only from the
region in which the trail was created (that is, from its home region).
}
\section{Request syntax}{
\preformatted{svc$add_tags(
  ResourceId = "string",
  TagsList = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
