% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_set_alarm_state}
\alias{cloudwatch_set_alarm_state}
\title{Temporarily sets the state of an alarm for testing purposes}
\usage{
cloudwatch_set_alarm_state(AlarmName, StateValue, StateReason,
  StateReasonData)
}
\arguments{
\item{AlarmName}{[required] The name for the alarm. This name must be unique within the AWS account.
The maximum length is 255 characters.}

\item{StateValue}{[required] The value of the state.}

\item{StateReason}{[required] The reason that this alarm is set to this specific state, in text
format.}

\item{StateReasonData}{The reason that this alarm is set to this specific state, in JSON
format.}
}
\description{
Temporarily sets the state of an alarm for testing purposes. When the
updated state differs from the previous value, the action configured for
the appropriate state is invoked. For example, if your alarm is
configured to send an Amazon SNS message when an alarm is triggered,
temporarily changing the alarm state to \code{ALARM} sends an SNS message.
The alarm returns to its actual state (often within seconds). Because
the alarm state change happens quickly, it is typically only visible in
the alarm's \strong{History} tab in the Amazon CloudWatch console or through
DescribeAlarmHistory.
}
\section{Request syntax}{
\preformatted{svc$set_alarm_state(
  AlarmName = "string",
  StateValue = "OK"|"ALARM"|"INSUFFICIENT_DATA",
  StateReason = "string",
  StateReasonData = "string"
)
}
}

\keyword{internal}
