% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_assign_volume}
\alias{opsworks_assign_volume}
\title{Assigns one of the stack's registered Amazon EBS volumes to a specified
instance}
\usage{
opsworks_assign_volume(VolumeId, InstanceId)
}
\arguments{
\item{VolumeId}{[required] The volume ID.}

\item{InstanceId}{The instance ID.}
}
\description{
Assigns one of the stack's registered Amazon EBS volumes to a specified
instance. The volume must first be registered with the stack by calling
RegisterVolume. After you register the volume, you must call
UpdateVolume to specify a mount point before calling \code{AssignVolume}. For
more information, see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html}{Resource Management}.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$assign_volume(
  VolumeId = "string",
  InstanceId = "string"
)
}
}

\keyword{internal}
