% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_detach_elastic_load_balancer}
\alias{opsworks_detach_elastic_load_balancer}
\title{Detaches a specified Elastic Load Balancing instance from its layer}
\usage{
opsworks_detach_elastic_load_balancer(ElasticLoadBalancerName, LayerId)
}
\arguments{
\item{ElasticLoadBalancerName}{[required] The Elastic Load Balancing instance's name.}

\item{LayerId}{[required] The ID of the layer that the Elastic Load Balancing instance is attached
to.}
}
\description{
Detaches a specified Elastic Load Balancing instance from its layer.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$detach_elastic_load_balancer(
  ElasticLoadBalancerName = "string",
  LayerId = "string"
)
}
}

\keyword{internal}
