% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_register_elastic_ip}
\alias{opsworks_register_elastic_ip}
\title{Registers an Elastic IP address with a specified stack}
\usage{
opsworks_register_elastic_ip(ElasticIp, StackId)
}
\arguments{
\item{ElasticIp}{[required] The Elastic IP address.}

\item{StackId}{[required] The stack ID.}
}
\description{
Registers an Elastic IP address with a specified stack. An address can
be registered with only one stack at a time. If the address is already
registered, you must first deregister it by calling DeregisterElasticIp.
For more information, see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html}{Resource Management}.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$register_elastic_ip(
  ElasticIp = "string",
  StackId = "string"
)
}
}

\keyword{internal}
