% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_unassign_instance}
\alias{opsworks_unassign_instance}
\title{Unassigns a registered instance from all layers that are using the
instance}
\usage{
opsworks_unassign_instance(InstanceId)
}
\arguments{
\item{InstanceId}{[required] The instance ID.}
}
\description{
Unassigns a registered instance from all layers that are using the
instance. The instance remains in the stack as an unassigned instance,
and can be assigned to another layer as needed. You cannot use this
action with instances that were created with AWS OpsWorks Stacks.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack or an attached policy that
explicitly grants permissions. For more information about user
permissions, see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$unassign_instance(
  InstanceId = "string"
)
}
}

\keyword{internal}
