% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_disable_policy_type}
\alias{organizations_disable_policy_type}
\title{Disables an organizational control policy type in a root}
\usage{
organizations_disable_policy_type(RootId, PolicyType)
}
\arguments{
\item{RootId}{[required] The unique identifier (ID) of the root in which you want to disable a
policy type. You can get the ID from the ListRoots operation.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a root ID
string requires "r-" followed by from 4 to 32 lower-case letters or
digits.}

\item{PolicyType}{[required] The policy type that you want to disable in this root.}
}
\description{
Disables an organizational control policy type in a root. A policy of a
certain type can be attached to entities in a root only if that type is
enabled in the root. After you perform this operation, you no longer can
attach policies of the specified type to that root or to any
organizational unit (OU) or account in that root. You can undo this by
using the EnablePolicyType operation.
}
\details{
This operation can be called only from the organization's master
account.

If you disable a policy type for a root, it still shows as enabled for
the organization if all features are enabled in that organization. Use
ListRoots to see the status of policy types for a specified root. Use
DescribeOrganization to see the status of policy types in the
organization.
}
\section{Request syntax}{
\preformatted{svc$disable_policy_type(
  RootId = "string",
  PolicyType = "SERVICE_CONTROL_POLICY"
)
}
}

\examples{
# The following example shows how to disable the service control policy
# (SCP) policy type in a root. The response shows that the PolicyTypes
# response element no longer includes SERVICE_CONTROL_POLICY:/n/n
\donttest{svc$disable_policy_type(
  PolicyType = "SERVICE_CONTROL_POLICY",
  RootId = "r-examplerootid111"
)}

}
\keyword{internal}
