# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include applicationautoscaling_service.R
NULL

#' Deletes the specified scaling policy for an Application Auto Scaling
#' scalable target
#'
#' @description
#' Deletes the specified scaling policy for an Application Auto Scaling
#' scalable target.
#' 
#' Deleting a step scaling policy deletes the underlying alarm action, but
#' does not delete the CloudWatch alarm associated with the scaling policy,
#' even if it no longer has an associated action.
#' 
#' For more information, see [Delete a Step Scaling
#' Policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html#delete-step-scaling-policy)
#' and [Delete a Target Tracking Scaling
#' Policy](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html#delete-target-tracking-policy)
#' in the *Application Auto Scaling User Guide*.
#'
#' @usage
#' applicationautoscaling_delete_scaling_policy(PolicyName,
#'   ServiceNamespace, ResourceId, ScalableDimension)
#'
#' @param PolicyName &#91;required&#93; The name of the scaling policy.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scalable target. This
#' string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#'
#' @section Request syntax:
#' ```
#' svc$delete_scaling_policy(
#'   PolicyName = "string",
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes a scaling policy for the Amazon ECS service called
#' # web-app, which is running in the default cluster.
#' svc$delete_scaling_policy(
#'   PolicyName = "web-app-cpu-lt-25",
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_delete_scaling_policy
applicationautoscaling_delete_scaling_policy <- function(PolicyName, ServiceNamespace, ResourceId, ScalableDimension) {
  op <- new_operation(
    name = "DeleteScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$delete_scaling_policy_input(PolicyName = PolicyName, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension)
  output <- .applicationautoscaling$delete_scaling_policy_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$delete_scaling_policy <- applicationautoscaling_delete_scaling_policy

#' Deletes the specified scheduled action for an Application Auto Scaling
#' scalable target
#'
#' @description
#' Deletes the specified scheduled action for an Application Auto Scaling
#' scalable target.
#' 
#' For more information, see [Delete a Scheduled
#' Action](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html#delete-scheduled-action)
#' in the *Application Auto Scaling User Guide*.
#'
#' @usage
#' applicationautoscaling_delete_scheduled_action(ServiceNamespace,
#'   ScheduledActionName, ResourceId, ScalableDimension)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ScheduledActionName &#91;required&#93; The name of the scheduled action.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scheduled action.
#' This string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#'
#' @section Request syntax:
#' ```
#' svc$delete_scheduled_action(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ScheduledActionName = "string",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_delete_scheduled_action
applicationautoscaling_delete_scheduled_action <- function(ServiceNamespace, ScheduledActionName, ResourceId, ScalableDimension) {
  op <- new_operation(
    name = "DeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$delete_scheduled_action_input(ServiceNamespace = ServiceNamespace, ScheduledActionName = ScheduledActionName, ResourceId = ResourceId, ScalableDimension = ScalableDimension)
  output <- .applicationautoscaling$delete_scheduled_action_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$delete_scheduled_action <- applicationautoscaling_delete_scheduled_action

#' Deregisters an Application Auto Scaling scalable target when you have
#' finished using it
#'
#' @description
#' Deregisters an Application Auto Scaling scalable target when you have
#' finished using it. To see which resources have been registered, use
#' [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
#' 
#' Deregistering a scalable target deletes the scaling policies and the
#' scheduled actions that are associated with it.
#'
#' @usage
#' applicationautoscaling_deregister_scalable_target(ServiceNamespace,
#'   ResourceId, ScalableDimension)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scalable target. This
#' string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension associated with the scalable target. This string
#' consists of the service namespace, resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_scalable_target(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deregisters a scalable target for an Amazon ECS service
#' # called web-app that is running in the default cluster.
#' svc$deregister_scalable_target(
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_deregister_scalable_target
applicationautoscaling_deregister_scalable_target <- function(ServiceNamespace, ResourceId, ScalableDimension) {
  op <- new_operation(
    name = "DeregisterScalableTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$deregister_scalable_target_input(ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension)
  output <- .applicationautoscaling$deregister_scalable_target_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$deregister_scalable_target <- applicationautoscaling_deregister_scalable_target

#' Gets information about the scalable targets in the specified namespace
#'
#' @description
#' Gets information about the scalable targets in the specified namespace.
#' 
#' You can filter the results using `ResourceIds` and `ScalableDimension`.
#'
#' @usage
#' applicationautoscaling_describe_scalable_targets(ServiceNamespace,
#'   ResourceIds, ScalableDimension, MaxResults, NextToken)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceIds The identifier of the resource associated with the scalable target. This
#' string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension The scalable dimension associated with the scalable target. This string
#' consists of the service namespace, resource type, and scaling property.
#' If you specify a scalable dimension, you must also specify a resource
#' ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#' @param MaxResults The maximum number of scalable targets. This value can be between 1 and
#' 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scalable_targets(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceIds = list(
#'     "string"
#'   ),
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the scalable targets for the ECS service
#' # namespace.
#' svc$describe_scalable_targets(
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scalable_targets
applicationautoscaling_describe_scalable_targets <- function(ServiceNamespace, ResourceIds = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalableTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scalable_targets_input(ServiceNamespace = ServiceNamespace, ResourceIds = ResourceIds, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scalable_targets_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scalable_targets <- applicationautoscaling_describe_scalable_targets

#' Provides descriptive information about the scaling activities in the
#' specified namespace from the previous six weeks
#'
#' @description
#' Provides descriptive information about the scaling activities in the
#' specified namespace from the previous six weeks.
#' 
#' You can filter the results using `ResourceId` and `ScalableDimension`.
#'
#' @usage
#' applicationautoscaling_describe_scaling_activities(ServiceNamespace,
#'   ResourceId, ScalableDimension, MaxResults, NextToken)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceId The identifier of the resource associated with the scaling activity.
#' This string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property. If you specify a scalable
#' dimension, you must also specify a resource ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#' @param MaxResults The maximum number of scalable targets. This value can be between 1 and
#' 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_activities(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the scaling activities for an Amazon ECS service
#' # called web-app that is running in the default cluster.
#' svc$describe_scaling_activities(
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scaling_activities
applicationautoscaling_describe_scaling_activities <- function(ServiceNamespace, ResourceId = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingActivities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scaling_activities_input(ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scaling_activities_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scaling_activities <- applicationautoscaling_describe_scaling_activities

#' Describes the Application Auto Scaling scaling policies for the
#' specified service namespace
#'
#' @description
#' Describes the Application Auto Scaling scaling policies for the
#' specified service namespace.
#' 
#' You can filter the results using `ResourceId`, `ScalableDimension`, and
#' `PolicyNames`.
#' 
#' For more information, see [Target Tracking Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
#' and [Step Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
#' in the *Application Auto Scaling User Guide*.
#'
#' @usage
#' applicationautoscaling_describe_scaling_policies(PolicyNames,
#'   ServiceNamespace, ResourceId, ScalableDimension, MaxResults, NextToken)
#'
#' @param PolicyNames The names of the scaling policies to describe.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceId The identifier of the resource associated with the scaling policy. This
#' string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property. If you specify a scalable
#' dimension, you must also specify a resource ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#' @param MaxResults The maximum number of scalable targets. This value can be between 1 and
#' 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_policies(
#'   PolicyNames = list(
#'     "string"
#'   ),
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the scaling policies for the ECS service
#' # namespace.
#' svc$describe_scaling_policies(
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scaling_policies
applicationautoscaling_describe_scaling_policies <- function(PolicyNames = NULL, ServiceNamespace, ResourceId = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scaling_policies_input(PolicyNames = PolicyNames, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scaling_policies_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scaling_policies <- applicationautoscaling_describe_scaling_policies

#' Describes the Application Auto Scaling scheduled actions for the
#' specified service namespace
#'
#' @description
#' Describes the Application Auto Scaling scheduled actions for the
#' specified service namespace.
#' 
#' You can filter the results using the `ResourceId`, `ScalableDimension`,
#' and `ScheduledActionNames` parameters.
#' 
#' For more information, see [Scheduled
#' Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html)
#' in the *Application Auto Scaling User Guide*.
#'
#' @usage
#' applicationautoscaling_describe_scheduled_actions(ScheduledActionNames,
#'   ServiceNamespace, ResourceId, ScalableDimension, MaxResults, NextToken)
#'
#' @param ScheduledActionNames The names of the scheduled actions to describe.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceId The identifier of the resource associated with the scheduled action.
#' This string consists of the resource type and unique identifier. If you
#' specify a scalable dimension, you must also specify a resource ID.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property. If you specify a scalable
#' dimension, you must also specify a resource ID.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#' @param MaxResults The maximum number of scheduled action results. This value can be
#' between 1 and 50. The default value is 50.
#' 
#' If this parameter is used, the operation returns up to `MaxResults`
#' results at a time, along with a `NextToken` value. To get the next set
#' of results, include the `NextToken` value in a subsequent call. If this
#' parameter is not used, the operation returns up to 50 results and a
#' `NextToken` value, if applicable.
#' @param NextToken The token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scheduled_actions(
#'   ScheduledActionNames = list(
#'     "string"
#'   ),
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_describe_scheduled_actions
applicationautoscaling_describe_scheduled_actions <- function(ScheduledActionNames = NULL, ServiceNamespace, ResourceId = NULL, ScalableDimension = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScheduledActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$describe_scheduled_actions_input(ScheduledActionNames = ScheduledActionNames, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationautoscaling$describe_scheduled_actions_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$describe_scheduled_actions <- applicationautoscaling_describe_scheduled_actions

#' Creates or updates a scaling policy for an Application Auto Scaling
#' scalable target
#'
#' @description
#' Creates or updates a scaling policy for an Application Auto Scaling
#' scalable target.
#' 
#' Each scalable target is identified by a service namespace, resource ID,
#' and scalable dimension. A scaling policy applies to the scalable target
#' identified by those three attributes. You cannot create a scaling policy
#' until you have registered the resource as a scalable target.
#' 
#' Multiple scaling policies can be in force at the same time for the same
#' scalable target. You can have one or more target tracking scaling
#' policies, one or more step scaling policies, or both. However, there is
#' a chance that multiple policies could conflict, instructing the scalable
#' target to scale out or in at the same time. Application Auto Scaling
#' gives precedence to the policy that provides the largest capacity for
#' both scale out and scale in. For example, if one policy increases
#' capacity by 3, another policy increases capacity by 200 percent, and the
#' current capacity is 10, Application Auto Scaling uses the policy with
#' the highest calculated capacity (200% of 10 = 20) and scales out to 30.
#' 
#' We recommend caution, however, when using target tracking scaling
#' policies with step scaling policies because conflicts between these
#' policies can cause undesirable behavior. For example, if the step
#' scaling policy initiates a scale-in activity before the target tracking
#' policy is ready to scale in, the scale-in activity will not be blocked.
#' After the scale-in activity completes, the target tracking policy could
#' instruct the scalable target to scale out again.
#' 
#' For more information, see [Target Tracking Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
#' and [Step Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
#' in the *Application Auto Scaling User Guide*.
#' 
#' If a scalable target is deregistered, the scalable target is no longer
#' available to execute scaling policies. Any scaling policies that were
#' specified for the scalable target are deleted.
#'
#' @usage
#' applicationautoscaling_put_scaling_policy(PolicyName, ServiceNamespace,
#'   ResourceId, ScalableDimension, PolicyType,
#'   StepScalingPolicyConfiguration,
#'   TargetTrackingScalingPolicyConfiguration)
#'
#' @param PolicyName &#91;required&#93; The name of the scaling policy.
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scaling policy. This
#' string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#' @param PolicyType The policy type. This parameter is required if you are creating a
#' scaling policy.
#' 
#' The following policy types are supported:
#' 
#' `TargetTrackingScaling`—Not supported for Amazon EMR
#' 
#' `StepScaling`—Not supported for DynamoDB, Amazon Comprehend, Lambda,
#' Amazon Keyspaces (for Apache Cassandra), or Amazon MSK.
#' 
#' For more information, see [Target Tracking Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html)
#' and [Step Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html)
#' in the *Application Auto Scaling User Guide*.
#' @param StepScalingPolicyConfiguration A step scaling policy.
#' 
#' This parameter is required if you are creating a policy and the policy
#' type is `StepScaling`.
#' @param TargetTrackingScalingPolicyConfiguration A target tracking scaling policy. Includes support for predefined or
#' customized metrics.
#' 
#' This parameter is required if you are creating a policy and the policy
#' type is `TargetTrackingScaling`.
#'
#' @section Request syntax:
#' ```
#' svc$put_scaling_policy(
#'   PolicyName = "string",
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize",
#'   PolicyType = "StepScaling"|"TargetTrackingScaling",
#'   StepScalingPolicyConfiguration = list(
#'     AdjustmentType = "ChangeInCapacity"|"PercentChangeInCapacity"|"ExactCapacity",
#'     StepAdjustments = list(
#'       list(
#'         MetricIntervalLowerBound = 123.0,
#'         MetricIntervalUpperBound = 123.0,
#'         ScalingAdjustment = 123
#'       )
#'     ),
#'     MinAdjustmentMagnitude = 123,
#'     Cooldown = 123,
#'     MetricAggregationType = "Average"|"Minimum"|"Maximum"
#'   ),
#'   TargetTrackingScalingPolicyConfiguration = list(
#'     TargetValue = 123.0,
#'     PredefinedMetricSpecification = list(
#'       PredefinedMetricType = "DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut"|"SageMakerVariantInvocationsPerInstance"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization"|"AppStreamAverageCapacityUtilization"|"ComprehendInferenceUtilization"|"LambdaProvisionedConcurrencyUtilization"|"CassandraReadCapacityUtilization"|"CassandraWriteCapacityUtilization"|"KafkaBrokerStorageUtilization",
#'       ResourceLabel = "string"
#'     ),
#'     CustomizedMetricSpecification = list(
#'       MetricName = "string",
#'       Namespace = "string",
#'       Dimensions = list(
#'         list(
#'           Name = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'       Unit = "string"
#'     ),
#'     ScaleOutCooldown = 123,
#'     ScaleInCooldown = 123,
#'     DisableScaleIn = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example applies a target tracking scaling policy with a
#' # predefined metric specification to an Amazon ECS service called web-app
#' # in the default cluster. The policy keeps the average CPU utilization of
#' # the service at 75 percent, with scale-out and scale-in cooldown periods
#' # of 60 seconds.
#' svc$put_scaling_policy(
#'   PolicyName = "cpu75-target-tracking-scaling-policy",
#'   PolicyType = "TargetTrackingScaling",
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs",
#'   TargetTrackingScalingPolicyConfiguration = list(
#'     PredefinedMetricSpecification = list(
#'       PredefinedMetricType = "ECSServiceAverageCPUUtilization"
#'     ),
#'     ScaleInCooldown = 60L,
#'     ScaleOutCooldown = 60L,
#'     TargetValue = 75L
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_put_scaling_policy
applicationautoscaling_put_scaling_policy <- function(PolicyName, ServiceNamespace, ResourceId, ScalableDimension, PolicyType = NULL, StepScalingPolicyConfiguration = NULL, TargetTrackingScalingPolicyConfiguration = NULL) {
  op <- new_operation(
    name = "PutScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$put_scaling_policy_input(PolicyName = PolicyName, ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, PolicyType = PolicyType, StepScalingPolicyConfiguration = StepScalingPolicyConfiguration, TargetTrackingScalingPolicyConfiguration = TargetTrackingScalingPolicyConfiguration)
  output <- .applicationautoscaling$put_scaling_policy_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$put_scaling_policy <- applicationautoscaling_put_scaling_policy

#' Creates or updates a scheduled action for an Application Auto Scaling
#' scalable target
#'
#' @description
#' Creates or updates a scheduled action for an Application Auto Scaling
#' scalable target.
#' 
#' Each scalable target is identified by a service namespace, resource ID,
#' and scalable dimension. A scheduled action applies to the scalable
#' target identified by those three attributes. You cannot create a
#' scheduled action until you have registered the resource as a scalable
#' target.
#' 
#' When start and end times are specified with a recurring schedule using a
#' cron expression or rates, they form the boundaries of when the recurring
#' action starts and stops.
#' 
#' To update a scheduled action, specify the parameters that you want to
#' change. If you don't specify start and end times, the old values are
#' deleted.
#' 
#' For more information, see [Scheduled
#' Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html)
#' in the *Application Auto Scaling User Guide*.
#' 
#' If a scalable target is deregistered, the scalable target is no longer
#' available to run scheduled actions. Any scheduled actions that were
#' specified for the scalable target are deleted.
#'
#' @usage
#' applicationautoscaling_put_scheduled_action(ServiceNamespace, Schedule,
#'   ScheduledActionName, ResourceId, ScalableDimension, StartTime, EndTime,
#'   ScalableTargetAction)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param Schedule The schedule for this action. The following formats are supported:
#' 
#' -   At expressions -
#'     "`at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)`"
#' 
#' -   Rate expressions - "`rate(<i>value</i> <i>unit</i>)`"
#' 
#' -   Cron expressions - "`cron(<i>fields</i>)`"
#' 
#' At expressions are useful for one-time schedules. Specify the time in
#' UTC.
#' 
#' For rate expressions, *value* is a positive integer and *unit* is
#' `minute` | `minutes` | `hour` | `hours` | `day` | `days`.
#' 
#' For cron expressions, *fields* is a cron expression. The supported cron
#' format consists of six fields separated by white spaces: \[Minutes\]
#' \[Hours\] \[Day\\_of\\_Month\] \[Month\] \[Day\\_of\\_Week\] \[Year\].
#' 
#' For more information and examples, see [Scheduled
#' Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html)
#' in the *Application Auto Scaling User Guide*.
#' @param ScheduledActionName &#91;required&#93; The name of the scheduled action. This name must be unique among all
#' other scheduled actions on the specified scalable target.
#' @param ResourceId &#91;required&#93; The identifier of the resource associated with the scheduled action.
#' This string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension. This string consists of the service namespace,
#' resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#' @param StartTime The date and time for this scheduled action to start.
#' @param EndTime The date and time for the recurring schedule to end.
#' @param ScalableTargetAction The new minimum and maximum capacity. You can set both values or just
#' one. At the scheduled time, if the current capacity is below the minimum
#' capacity, Application Auto Scaling scales out to the minimum capacity.
#' If the current capacity is above the maximum capacity, Application Auto
#' Scaling scales in to the maximum capacity.
#'
#' @section Request syntax:
#' ```
#' svc$put_scheduled_action(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   Schedule = "string",
#'   ScheduledActionName = "string",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ScalableTargetAction = list(
#'     MinCapacity = 123,
#'     MaxCapacity = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_put_scheduled_action
applicationautoscaling_put_scheduled_action <- function(ServiceNamespace, Schedule = NULL, ScheduledActionName, ResourceId, ScalableDimension, StartTime = NULL, EndTime = NULL, ScalableTargetAction = NULL) {
  op <- new_operation(
    name = "PutScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$put_scheduled_action_input(ServiceNamespace = ServiceNamespace, Schedule = Schedule, ScheduledActionName = ScheduledActionName, ResourceId = ResourceId, ScalableDimension = ScalableDimension, StartTime = StartTime, EndTime = EndTime, ScalableTargetAction = ScalableTargetAction)
  output <- .applicationautoscaling$put_scheduled_action_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$put_scheduled_action <- applicationautoscaling_put_scheduled_action

#' Registers or updates a scalable target
#'
#' @description
#' Registers or updates a scalable target.
#' 
#' A scalable target is a resource that Application Auto Scaling can scale
#' out and scale in. Scalable targets are uniquely identified by the
#' combination of resource ID, scalable dimension, and namespace.
#' 
#' When you register a new scalable target, you must specify values for
#' minimum and maximum capacity. Current capacity will be adjusted within
#' the specified range when scaling starts. Application Auto Scaling
#' scaling policies will not scale capacity to values that are outside of
#' this range.
#' 
#' After you register a scalable target, you do not need to register it
#' again to use other Application Auto Scaling operations. To see which
#' resources have been registered, use
#' [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
#' You can also view the scaling policies for a service namespace by using
#' [DescribeScalableTargets](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html).
#' If you no longer need a scalable target, you can deregister it by using
#' [DeregisterScalableTarget](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html).
#' 
#' To update a scalable target, specify the parameters that you want to
#' change. Include the parameters that identify the scalable target:
#' resource ID, scalable dimension, and namespace. Any parameters that you
#' don't specify are not changed by this update request.
#'
#' @usage
#' applicationautoscaling_register_scalable_target(ServiceNamespace,
#'   ResourceId, ScalableDimension, MinCapacity, MaxCapacity, RoleARN,
#'   SuspendedState)
#'
#' @param ServiceNamespace &#91;required&#93; The namespace of the AWS service that provides the resource. For a
#' resource provided by your own application or service, use
#' `custom-resource` instead.
#' @param ResourceId &#91;required&#93; The identifier of the resource that is associated with the scalable
#' target. This string consists of the resource type and unique identifier.
#' 
#' -   ECS service - The resource type is `service` and the unique
#'     identifier is the cluster name and service name. Example:
#'     `service/default/sample-webapp`.
#' 
#' -   Spot Fleet request - The resource type is `spot-fleet-request` and
#'     the unique identifier is the Spot Fleet request ID. Example:
#'     `spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE`.
#' 
#' -   EMR cluster - The resource type is `instancegroup` and the unique
#'     identifier is the cluster ID and instance group ID. Example:
#'     `instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0`.
#' 
#' -   AppStream 2.0 fleet - The resource type is `fleet` and the unique
#'     identifier is the fleet name. Example: `fleet/sample-fleet`.
#' 
#' -   DynamoDB table - The resource type is `table` and the unique
#'     identifier is the table name. Example: `table/my-table`.
#' 
#' -   DynamoDB global secondary index - The resource type is `index` and
#'     the unique identifier is the index name. Example:
#'     `table/my-table/index/my-table-index`.
#' 
#' -   Aurora DB cluster - The resource type is `cluster` and the unique
#'     identifier is the cluster name. Example: `cluster:my-db-cluster`.
#' 
#' -   Amazon SageMaker endpoint variant - The resource type is `variant`
#'     and the unique identifier is the resource ID. Example:
#'     `endpoint/my-end-point/variant/KMeansClustering`.
#' 
#' -   Custom resources are not supported with a resource type. This
#'     parameter must specify the `OutputValue` from the CloudFormation
#'     template stack used to access the resources. The unique identifier
#'     is defined by the service provider. More information is available in
#'     our [GitHub
#'     repository](https://github.com/aws/aws-auto-scaling-custom-resource).
#' 
#' -   Amazon Comprehend document classification endpoint - The resource
#'     type and unique identifier are specified using the endpoint ARN.
#'     Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE`.
#' 
#' -   Amazon Comprehend entity recognizer endpoint - The resource type and
#'     unique identifier are specified using the endpoint ARN. Example:
#'     `arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE`.
#' 
#' -   Lambda provisioned concurrency - The resource type is `function` and
#'     the unique identifier is the function name with a function version
#'     or alias name suffix that is not `$LATEST`. Example:
#'     `function:my-function:prod` or `function:my-function:1`.
#' 
#' -   Amazon Keyspaces table - The resource type is `table` and the unique
#'     identifier is the table name. Example:
#'     `keyspace/mykeyspace/table/mytable`.
#' 
#' -   Amazon MSK cluster - The resource type and unique identifier are
#'     specified using the cluster ARN. Example:
#'     `arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5`.
#' @param ScalableDimension &#91;required&#93; The scalable dimension associated with the scalable target. This string
#' consists of the service namespace, resource type, and scaling property.
#' 
#' -   `ecs:service:DesiredCount` - The desired task count of an ECS
#'     service.
#' 
#' -   `ec2:spot-fleet-request:TargetCapacity` - The target capacity of a
#'     Spot Fleet request.
#' 
#' -   `elasticmapreduce:instancegroup:InstanceCount` - The instance count
#'     of an EMR Instance Group.
#' 
#' -   `appstream:fleet:DesiredCapacity` - The desired capacity of an
#'     AppStream 2.0 fleet.
#' 
#' -   `dynamodb:table:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:table:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB table.
#' 
#' -   `dynamodb:index:ReadCapacityUnits` - The provisioned read capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `dynamodb:index:WriteCapacityUnits` - The provisioned write capacity
#'     for a DynamoDB global secondary index.
#' 
#' -   `rds:cluster:ReadReplicaCount` - The count of Aurora Replicas in an
#'     Aurora DB cluster. Available for Aurora MySQL-compatible edition and
#'     Aurora PostgreSQL-compatible edition.
#' 
#' -   `sagemaker:variant:DesiredInstanceCount` - The number of EC2
#'     instances for an Amazon SageMaker model endpoint variant.
#' 
#' -   `custom-resource:ResourceType:Property` - The scalable dimension for
#'     a custom resource provided by your own application or service.
#' 
#' -   `comprehend:document-classifier-endpoint:DesiredInferenceUnits` -
#'     The number of inference units for an Amazon Comprehend document
#'     classification endpoint.
#' 
#' -   `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits` - The
#'     number of inference units for an Amazon Comprehend entity recognizer
#'     endpoint.
#' 
#' -   `lambda:function:ProvisionedConcurrency` - The provisioned
#'     concurrency for a Lambda function.
#' 
#' -   `cassandra:table:ReadCapacityUnits` - The provisioned read capacity
#'     for an Amazon Keyspaces table.
#' 
#' -   `cassandra:table:WriteCapacityUnits` - The provisioned write
#'     capacity for an Amazon Keyspaces table.
#' 
#' -   `kafka:broker-storage:VolumeSize` - The provisioned volume size (in
#'     GiB) for brokers in an Amazon MSK cluster.
#' @param MinCapacity The minimum value that you plan to scale in to. When a scaling policy is
#' in effect, Application Auto Scaling can scale in (contract) as needed to
#' the minimum capacity limit in response to changing demand. This property
#' is required when registering a new scalable target.
#' 
#' For certain resources, the minimum value allowed is 0. This includes
#' Lambda provisioned concurrency, Spot Fleet, ECS services, Aurora DB
#' clusters, EMR clusters, and custom resources. For all other resources,
#' the minimum value allowed is 1.
#' @param MaxCapacity The maximum value that you plan to scale out to. When a scaling policy
#' is in effect, Application Auto Scaling can scale out (expand) as needed
#' to the maximum capacity limit in response to changing demand. This
#' property is required when registering a new scalable target.
#' 
#' Although you can specify a large maximum capacity, note that service
#' quotas may impose lower limits. Each service has its own default quotas
#' for the maximum capacity of the resource. If you want to specify a
#' higher limit, you can request an increase. For more information, consult
#' the documentation for that service. For information about the default
#' quotas for each service, see [Service Endpoints and
#' Quotas](https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html)
#' in the *Amazon Web Services General Reference*.
#' @param RoleARN This parameter is required for services that do not support
#' service-linked roles (such as Amazon EMR), and it must specify the ARN
#' of an IAM role that allows Application Auto Scaling to modify the
#' scalable target on your behalf.
#' 
#' If the service supports service-linked roles, Application Auto Scaling
#' uses a service-linked role, which it creates if it does not yet exist.
#' For more information, see [Application Auto Scaling IAM
#' Roles](https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles).
#' @param SuspendedState An embedded object that contains attributes and attribute values that
#' are used to suspend and resume automatic scaling. Setting the value of
#' an attribute to `true` suspends the specified scaling activities.
#' Setting it to `false` (default) resumes the specified scaling
#' activities.
#' 
#' **Suspension Outcomes**
#' 
#' -   For `DynamicScalingInSuspended`, while a suspension is in effect,
#'     all scale-in activities that are triggered by a scaling policy are
#'     suspended.
#' 
#' -   For `DynamicScalingOutSuspended`, while a suspension is in effect,
#'     all scale-out activities that are triggered by a scaling policy are
#'     suspended.
#' 
#' -   For `ScheduledScalingSuspended`, while a suspension is in effect,
#'     all scaling activities that involve scheduled actions are suspended.
#' 
#' For more information, see [Suspending and Resuming
#' Scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html)
#' in the *Application Auto Scaling User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$register_scalable_target(
#'   ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra"|"kafka",
#'   ResourceId = "string",
#'   ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits"|"kafka:broker-storage:VolumeSize",
#'   MinCapacity = 123,
#'   MaxCapacity = 123,
#'   RoleARN = "string",
#'   SuspendedState = list(
#'     DynamicScalingInSuspended = TRUE|FALSE,
#'     DynamicScalingOutSuspended = TRUE|FALSE,
#'     ScheduledScalingSuspended = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example registers a scalable target from an Amazon ECS service
#' # called web-app that is running on the default cluster, with a minimum
#' # desired count of 1 task and a maximum desired count of 10 tasks.
#' svc$register_scalable_target(
#'   MaxCapacity = 10L,
#'   MinCapacity = 1L,
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname applicationautoscaling_register_scalable_target
applicationautoscaling_register_scalable_target <- function(ServiceNamespace, ResourceId, ScalableDimension, MinCapacity = NULL, MaxCapacity = NULL, RoleARN = NULL, SuspendedState = NULL) {
  op <- new_operation(
    name = "RegisterScalableTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationautoscaling$register_scalable_target_input(ServiceNamespace = ServiceNamespace, ResourceId = ResourceId, ScalableDimension = ScalableDimension, MinCapacity = MinCapacity, MaxCapacity = MaxCapacity, RoleARN = RoleARN, SuspendedState = SuspendedState)
  output <- .applicationautoscaling$register_scalable_target_output()
  config <- get_config()
  svc <- .applicationautoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationautoscaling$operations$register_scalable_target <- applicationautoscaling_register_scalable_target
