% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_query_definition}
\alias{cloudwatchlogs_put_query_definition}
\title{Creates or updates a query definition for CloudWatch Logs Insights}
\usage{
cloudwatchlogs_put_query_definition(name, queryDefinitionId,
  logGroupNames, queryString)
}
\arguments{
\item{name}{[required] A name for the query definition. If you are saving a lot of query
definitions, we recommend that you name them so that you can easily find
the ones you want by using the first part of the name as a filter in the
\code{queryDefinitionNamePrefix} parameter of
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html}{DescribeQueryDefinitions}.}

\item{queryDefinitionId}{If you are updating a query definition, use this parameter to specify
the ID of the query definition that you want to update. You can use
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html}{DescribeQueryDefinitions}
to retrieve the IDs of your saved query definitions.

If you are creating a query definition, do not specify this parameter.
CloudWatch generates a unique ID for the new query definition and
include it in the response to this operation.}

\item{logGroupNames}{Use this parameter to include specific log groups as part of your query
definition.

If you are updating a query definition and you omit this parameter, then
the updated definition will contain no log groups.}

\item{queryString}{[required] The query string to use for this definition. For more information, see
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html}{CloudWatch Logs Insights Query Syntax}.}
}
\description{
Creates or updates a query definition for CloudWatch Logs Insights. For
more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html}{Analyzing Log Data with CloudWatch Logs Insights}.

To update a query definition, specify its \code{queryDefinitionId} in your
request. The values of \code{name}, \code{queryString}, and \code{logGroupNames} are
changed to the values that you specify in your update operation. No
current values are retained from the current query definition. For
example, if you update a current query definition that includes log
groups, and you don't specify the \code{logGroupNames} parameter in your
update operation, the query definition changes to contain no log groups.

You must have the \code{logs:PutQueryDefinition} permission to be able to
perform this operation.
}
\section{Request syntax}{
\preformatted{svc$put_query_definition(
  name = "string",
  queryDefinitionId = "string",
  logGroupNames = list(
    "string"
  ),
  queryString = "string"
)
}
}

\keyword{internal}
