% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_configuration_aggregator}
\alias{configservice_put_configuration_aggregator}
\title{Creates and updates the configuration aggregator with the selected
source accounts and regions}
\usage{
configservice_put_configuration_aggregator(ConfigurationAggregatorName,
  AccountAggregationSources, OrganizationAggregationSource, Tags)
}
\arguments{
\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{AccountAggregationSources}{A list of AccountAggregationSource object.}

\item{OrganizationAggregationSource}{An OrganizationAggregationSource object.}

\item{Tags}{An array of tag object.}
}
\description{
Creates and updates the configuration aggregator with the selected
source accounts and regions. The source account can be individual
account(s) or an organization.

AWS Config should be enabled in source accounts and regions you want to
aggregate.

If your source type is an organization, you must be signed in to the
master account and all features must be enabled in your organization.
AWS Config calls \code{EnableAwsServiceAccess} API to enable integration
between AWS Config and AWS Organizations.
}
\section{Request syntax}{
\preformatted{svc$put_configuration_aggregator(
  ConfigurationAggregatorName = "string",
  AccountAggregationSources = list(
    list(
      AccountIds = list(
        "string"
      ),
      AllAwsRegions = TRUE|FALSE,
      AwsRegions = list(
        "string"
      )
    )
  ),
  OrganizationAggregationSource = list(
    RoleArn = "string",
    AwsRegions = list(
      "string"
    ),
    AllAwsRegions = TRUE|FALSE
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
