% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_license_version}
\alias{licensemanager_create_license_version}
\title{Creates a new version of the specified license}
\usage{
licensemanager_create_license_version(LicenseArn, LicenseName,
  ProductName, Issuer, HomeRegion, Validity, LicenseMetadata,
  Entitlements, ConsumptionConfiguration, Status, ClientToken,
  SourceVersion)
}
\arguments{
\item{LicenseArn}{[required] Amazon Resource Name (ARN) of the license.}

\item{LicenseName}{[required] License name.}

\item{ProductName}{[required] Product name.}

\item{Issuer}{[required] License issuer.}

\item{HomeRegion}{[required] Home Region of the license.}

\item{Validity}{[required] Date and time range during which the license is valid, in ISO8601-UTC
format.}

\item{LicenseMetadata}{Information about the license.}

\item{Entitlements}{[required] License entitlements.}

\item{ConsumptionConfiguration}{[required] Configuration for consumption of the license. Choose a provisional
configuration for workloads running with continuous connectivity. Choose
a borrow configuration for workloads with offline usage.}

\item{Status}{[required] License status.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{SourceVersion}{Current version of the license.}
}
\description{
Creates a new version of the specified license.
}
\section{Request syntax}{
\preformatted{svc$create_license_version(
  LicenseArn = "string",
  LicenseName = "string",
  ProductName = "string",
  Issuer = list(
    Name = "string",
    SignKey = "string"
  ),
  HomeRegion = "string",
  Validity = list(
    Begin = "string",
    End = "string"
  ),
  LicenseMetadata = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  Entitlements = list(
    list(
      Name = "string",
      Value = "string",
      MaxCount = 123,
      Overage = TRUE|FALSE,
      Unit = "Count"|"None"|"Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second",
      AllowCheckIn = TRUE|FALSE
    )
  ),
  ConsumptionConfiguration = list(
    RenewType = "None"|"Weekly"|"Monthly",
    ProvisionalConfiguration = list(
      MaxTimeToLiveInMinutes = 123
    ),
    BorrowConfiguration = list(
      AllowEarlyCheckIn = TRUE|FALSE,
      MaxTimeToLiveInMinutes = 123
    )
  ),
  Status = "AVAILABLE"|"PENDING_AVAILABLE"|"DEACTIVATED"|"SUSPENDED"|"EXPIRED"|"PENDING_DELETE"|"DELETED",
  ClientToken = "string",
  SourceVersion = "string"
)
}
}

\keyword{internal}
