% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_delete_organizational_unit}
\alias{organizations_delete_organizational_unit}
\title{Deletes an organizational unit (OU) from a root or another OU}
\usage{
organizations_delete_organizational_unit(OrganizationalUnitId)
}
\arguments{
\item{OrganizationalUnitId}{[required] The unique identifier (ID) of the organizational unit that you want to
delete. You can get the ID from the ListOrganizationalUnitsForParent
operation.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for an
organizational unit ID string requires "ou-" followed by from 4 to 32
lowercase letters or digits (the ID of the root that contains the OU).
This string is followed by a second "-" dash and from 8 to 32 additional
lowercase letters or digits.}
}
\description{
Deletes an organizational unit (OU) from a root or another OU. You must
first remove all accounts and child OUs from the OU that you want to
delete.

This operation can be called only from the organization's management
account.
}
\section{Request syntax}{
\preformatted{svc$delete_organizational_unit(
  OrganizationalUnitId = "string"
)
}
}

\examples{
\dontrun{
# The following example shows how to delete an OU. The example assumes
# that you previously removed all accounts and other OUs from the OU:
# 
# 
svc$delete_organizational_unit(
  OrganizationalUnitId = "ou-examplerootid111-exampleouid111"
)
}

}
\keyword{internal}
