% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_import_as_provisioned_product}
\alias{servicecatalog_import_as_provisioned_product}
\title{Requests the import of a resource as a Service Catalog provisioned
product that is associated to a Service Catalog product and provisioning
artifact}
\usage{
servicecatalog_import_as_provisioned_product(AcceptLanguage, ProductId,
  ProvisioningArtifactId, ProvisionedProductName, PhysicalId,
  IdempotencyToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{ProvisioningArtifactId}{[required] The identifier of the provisioning artifact.}

\item{ProvisionedProductName}{[required] The user-friendly name of the provisioned product. The value must be
unique for the AWS account. The name cannot be updated after the product
is provisioned.}

\item{PhysicalId}{[required] The unique identifier of the resource to be imported. It only currently
supports CloudFormation stack IDs.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\description{
Requests the import of a resource as a Service Catalog provisioned
product that is associated to a Service Catalog product and provisioning
artifact. Once imported, all supported Service Catalog governance
actions are supported on the provisioned product.

Resource import only supports CloudFormation stack ARNs. CloudFormation
StackSets and non-root nested stacks are not supported.

The CloudFormation stack must have one of the following statuses to be
imported: \code{CREATE_COMPLETE}, \code{UPDATE_COMPLETE},
\code{UPDATE_ROLLBACK_COMPLETE}, \code{IMPORT_COMPLETE},
\code{IMPORT_ROLLBACK_COMPLETE}.

Import of the resource requires that the CloudFormation stack template
matches the associated Service Catalog product provisioning artifact.

The user or role that performs this operation must have the
\code{cloudformation:GetTemplate} and \code{cloudformation:DescribeStacks} IAM
policy permissions.
}
\section{Request syntax}{
\preformatted{svc$import_as_provisioned_product(
  AcceptLanguage = "string",
  ProductId = "string",
  ProvisioningArtifactId = "string",
  ProvisionedProductName = "string",
  PhysicalId = "string",
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
