% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_terminate_provisioned_product}
\alias{servicecatalog_terminate_provisioned_product}
\title{Terminates the specified provisioned product}
\usage{
servicecatalog_terminate_provisioned_product(ProvisionedProductName,
  ProvisionedProductId, TerminateToken, IgnoreErrors, AcceptLanguage,
  RetainPhysicalResources)
}
\arguments{
\item{ProvisionedProductName}{The name of the provisioned product. You cannot specify both
\code{ProvisionedProductName} and \code{ProvisionedProductId}.}

\item{ProvisionedProductId}{The identifier of the provisioned product. You cannot specify both
\code{ProvisionedProductName} and \code{ProvisionedProductId}.}

\item{TerminateToken}{[required] An idempotency token that uniquely identifies the termination request.
This token is only valid during the termination process. After the
provisioned product is terminated, subsequent requests to terminate the
same provisioned product always return \strong{ResourceNotFound}.}

\item{IgnoreErrors}{If set to true, AWS Service Catalog stops managing the specified
provisioned product even if it cannot delete the underlying resources.}

\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{RetainPhysicalResources}{When this boolean parameter is set to true, the
\code{TerminateProvisionedProduct} API deletes the Service Catalog
provisioned product. However, it does not remove the CloudFormation
stack, stack set, or the underlying resources of the deleted provisioned
product. The default value is false.}
}
\description{
Terminates the specified provisioned product.

This operation does not delete any records associated with the
provisioned product.

You can check the status of this request using DescribeRecord.
}
\section{Request syntax}{
\preformatted{svc$terminate_provisioned_product(
  ProvisionedProductName = "string",
  ProvisionedProductId = "string",
  TerminateToken = "string",
  IgnoreErrors = TRUE|FALSE,
  AcceptLanguage = "string",
  RetainPhysicalResources = TRUE|FALSE
)
}
}

\keyword{internal}
