% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_remediation_configurations}
\alias{configservice_put_remediation_configurations}
\title{Adds or updates the remediation configuration with a specific AWS Config
rule with the selected target or action}
\usage{
configservice_put_remediation_configurations(RemediationConfigurations)
}
\arguments{
\item{RemediationConfigurations}{[required] A list of remediation configuration objects.}
}
\value{
A list with the following syntax:\preformatted{list(
  FailedBatches = list(
    list(
      FailureMessage = "string",
      FailedItems = list(
        list(
          ConfigRuleName = "string",
          TargetType = "SSM_DOCUMENT",
          TargetId = "string",
          TargetVersion = "string",
          Parameters = list(
            list(
              ResourceValue = list(
                Value = "RESOURCE_ID"
              ),
              StaticValue = list(
                Values = list(
                  "string"
                )
              )
            )
          ),
          ResourceType = "string",
          Automatic = TRUE|FALSE,
          ExecutionControls = list(
            SsmControls = list(
              ConcurrentExecutionRatePercentage = 123,
              ErrorPercentage = 123
            )
          ),
          MaximumAutomaticAttempts = 123,
          RetryAttemptSeconds = 123,
          Arn = "string",
          CreatedByService = "string"
        )
      )
    )
  )
)
}
}
\description{
Adds or updates the remediation configuration with a specific AWS Config
rule with the selected target or action. The API creates the
\code{RemediationConfiguration} object for the AWS Config rule. The AWS
Config rule must already exist for you to add a remediation
configuration. The target (SSM document) must exist and have permissions
to use the target.

If you make backward incompatible changes to the SSM document, you must
call this again to ensure the remediations can run.

This API does not support adding remediation configurations for
service-linked AWS Config Rules such as Organization Config rules, the
rules deployed by conformance packs, and rules deployed by AWS Security
Hub.
}
\section{Request syntax}{
\preformatted{svc$put_remediation_configurations(
  RemediationConfigurations = list(
    list(
      ConfigRuleName = "string",
      TargetType = "SSM_DOCUMENT",
      TargetId = "string",
      TargetVersion = "string",
      Parameters = list(
        list(
          ResourceValue = list(
            Value = "RESOURCE_ID"
          ),
          StaticValue = list(
            Values = list(
              "string"
            )
          )
        )
      ),
      ResourceType = "string",
      Automatic = TRUE|FALSE,
      ExecutionControls = list(
        SsmControls = list(
          ConcurrentExecutionRatePercentage = 123,
          ErrorPercentage = 123
        )
      ),
      MaximumAutomaticAttempts = 123,
      RetryAttemptSeconds = 123,
      Arn = "string",
      CreatedByService = "string"
    )
  )
)
}
}

\keyword{internal}
