% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_create_group}
\alias{resourcegroups_create_group}
\title{Creates a resource group with the specified name and description}
\usage{
resourcegroups_create_group(Name, Description, ResourceQuery, Tags,
  Configuration)
}
\arguments{
\item{Name}{[required] The name of the group, which is the identifier of the group in other
operations. You can't change the name of a resource group after you
create it. A resource group name can consist of letters, numbers,
hyphens, periods, and underscores. The name cannot start with \code{AWS} or
\code{aws}; these are reserved. A resource group name must be unique within
each AWS Region in your AWS account.}

\item{Description}{The description of the resource group. Descriptions can consist of
letters, numbers, hyphens, underscores, periods, and spaces.}

\item{ResourceQuery}{The resource query that determines which AWS resources are members of
this group. For more information about resource queries, see \href{https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag}{Create a tag-based group in Resource Groups}.

A resource group can contain either a \code{ResourceQuery} or a
\code{Configuration}, but not both.}

\item{Tags}{The tags to add to the group. A tag is key-value pair string.}

\item{Configuration}{A configuration associates the resource group with an AWS service and
specifies how the service can interact with the resources in the group.
A configuration is an array of GroupConfigurationItem elements. For
details about the syntax of service configurations, see \href{https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html}{Service configurations for resource groups}.

A resource group can contain either a \code{Configuration} or a
\code{ResourceQuery}, but not both.}
}
\value{
A list with the following syntax:\preformatted{list(
  Group = list(
    GroupArn = "string",
    Name = "string",
    Description = "string"
  ),
  ResourceQuery = list(
    Type = "TAG_FILTERS_1_0"|"CLOUDFORMATION_STACK_1_0",
    Query = "string"
  ),
  Tags = list(
    "string"
  ),
  GroupConfiguration = list(
    Configuration = list(
      list(
        Type = "string",
        Parameters = list(
          list(
            Name = "string",
            Values = list(
              "string"
            )
          )
        )
      )
    ),
    ProposedConfiguration = list(
      list(
        Type = "string",
        Parameters = list(
          list(
            Name = "string",
            Values = list(
              "string"
            )
          )
        )
      )
    ),
    Status = "UPDATING"|"UPDATE_COMPLETE"|"UPDATE_FAILED",
    FailureReason = "string"
  )
)
}
}
\description{
Creates a resource group with the specified name and description. You
can optionally include a resource query, or a service configuration. For
more information about constructing a resource query, see \href{https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag}{Create a tag-based group in Resource Groups}.
For more information about service configurations, see \href{https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html}{Service configurations for resource groups}.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item \code{resource-groups:CreateGroup}
}
}
\section{Request syntax}{
\preformatted{svc$create_group(
  Name = "string",
  Description = "string",
  ResourceQuery = list(
    Type = "TAG_FILTERS_1_0"|"CLOUDFORMATION_STACK_1_0",
    Query = "string"
  ),
  Tags = list(
    "string"
  ),
  Configuration = list(
    list(
      Type = "string",
      Parameters = list(
        list(
          Name = "string",
          Values = list(
            "string"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
