% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_describe_provisioning_parameters}
\alias{servicecatalog_describe_provisioning_parameters}
\title{Gets information about the configuration required to provision the
specified product using the specified provisioning artifact}
\usage{
servicecatalog_describe_provisioning_parameters(AcceptLanguage,
  ProductId, ProductName, ProvisioningArtifactId,
  ProvisioningArtifactName, PathId, PathName)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{The product identifier. You must provide the product name or ID, but not
both.}

\item{ProductName}{The name of the product. You must provide the name or ID, but not both.}

\item{ProvisioningArtifactId}{The identifier of the provisioning artifact. You must provide the name
or ID, but not both.}

\item{ProvisioningArtifactName}{The name of the provisioning artifact. You must provide the name or ID,
but not both.}

\item{PathId}{The path identifier of the product. This value is optional if the
product has a default path, and required if the product has more than
one path. To list the paths for a product, use
\code{\link[=servicecatalog_list_launch_paths]{list_launch_paths}}. You must
provide the name or ID, but not both.}

\item{PathName}{The name of the path. You must provide the name or ID, but not both.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProvisioningArtifactParameters = list(
    list(
      ParameterKey = "string",
      DefaultValue = "string",
      ParameterType = "string",
      IsNoEcho = TRUE|FALSE,
      Description = "string",
      ParameterConstraints = list(
        AllowedValues = list(
          "string"
        ),
        AllowedPattern = "string",
        ConstraintDescription = "string",
        MaxLength = "string",
        MinLength = "string",
        MaxValue = "string",
        MinValue = "string"
      )
    )
  ),
  ConstraintSummaries = list(
    list(
      Type = "string",
      Description = "string"
    )
  ),
  UsageInstructions = list(
    list(
      Type = "string",
      Value = "string"
    )
  ),
  TagOptions = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  ProvisioningArtifactPreferences = list(
    StackSetAccounts = list(
      "string"
    ),
    StackSetRegions = list(
      "string"
    )
  ),
  ProvisioningArtifactOutputs = list(
    list(
      Key = "string",
      Description = "string"
    )
  )
)
}
}
\description{
Gets information about the configuration required to provision the
specified product using the specified provisioning artifact.

If the output contains a TagOption key with an empty list of values,
there is a TagOption conflict for that key. The end user cannot take
action to fix the conflict, and launch is not blocked. In subsequent
calls to \code{\link[=servicecatalog_provision_product]{provision_product}}, do not
include conflicted TagOption keys as tags, or this causes the error
"Parameter validation failed: Missing required parameter in
Tags[\emph{N}]:\emph{Value}". Tag the provisioned product with the value
\code{sc-tagoption-conflict-portfolioId-productId}.
}
\section{Request syntax}{
\preformatted{svc$describe_provisioning_parameters(
  AcceptLanguage = "string",
  ProductId = "string",
  ProductName = "string",
  ProvisioningArtifactId = "string",
  ProvisioningArtifactName = "string",
  PathId = "string",
  PathName = "string"
)
}
}

\keyword{internal}
