# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include cloudwatchevents_service.R
NULL

#' Activates a partner event source that has been deactivated
#'
#' Activates a partner event source that has been deactivated. Once
#' activated, your matching event bus will start receiving events from the
#' event source.
#' 
#' This operation is performed by AWS customers, not by SaaS partners.
#'
#' @usage
#' cloudwatchevents_activate_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the partner event source to activate.
#'
#' @section Request syntax:
#' ```
#' svc$activate_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_activate_event_source
cloudwatchevents_activate_event_source <- function(Name) {
  op <- new_operation(
    name = "ActivateEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$activate_event_source_input(Name = Name)
  output <- .cloudwatchevents$activate_event_source_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$activate_event_source <- cloudwatchevents_activate_event_source

#' Creates a new event bus within your account
#'
#' Creates a new event bus within your account. This can be a custom event
#' bus which you can use to receive events from your own custom
#' applications and services, or it can be a partner event bus which can be
#' matched to a partner event source.
#' 
#' This operation is used by AWS customers, not by SaaS partners.
#'
#' @usage
#' cloudwatchevents_create_event_bus(Name, EventSourceName)
#'
#' @param Name &#91;required&#93; The name of the new event bus.
#' 
#' The names of custom event buses can\'t contain the `/` character. You
#' can\'t use the name `default` for a custom event bus because this name
#' is already used for your account\'s default event bus.
#' 
#' If this is a partner event bus, the name must exactly match the name of
#' the partner event source that this event bus is matched to. This name
#' will include the `/` character.
#' @param EventSourceName If you\'re creating a partner event bus, this specifies the partner
#' event source that the new event bus will be matched with.
#'
#' @section Request syntax:
#' ```
#' svc$create_event_bus(
#'   Name = "string",
#'   EventSourceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_create_event_bus
cloudwatchevents_create_event_bus <- function(Name, EventSourceName = NULL) {
  op <- new_operation(
    name = "CreateEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$create_event_bus_input(Name = Name, EventSourceName = EventSourceName)
  output <- .cloudwatchevents$create_event_bus_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$create_event_bus <- cloudwatchevents_create_event_bus

#' Called by an SaaS partner to create a partner event source
#'
#' Called by an SaaS partner to create a partner event source.
#' 
#' This operation is not used by AWS customers.
#' 
#' Each partner event source can be used by one AWS account to create a
#' matching partner event bus in that AWS account. A SaaS partner must
#' create one partner event source for each AWS account that wants to
#' receive those event types.
#' 
#' A partner event source creates events based on resources in the SaaS
#' partner\'s service or application.
#' 
#' An AWS account that creates a partner event bus that matches the partner
#' event source can use that event bus to receive events from the partner,
#' and then process them using AWS Events rules and targets.
#' 
#' Partner event source names follow this format:
#' 
#' `aws.partner/<i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> `
#' 
#' -   *partner\\_name* is determined during partner registration and
#'     identifies the partner to AWS customers.
#' 
#' -   For *event\\_namespace*, we recommend that partners use a string that
#'     identifies the AWS customer within the partner\'s system. This
#'     should not be the customer\'s AWS account ID.
#' 
#' -   *event\\_name* is determined by the partner, and should uniquely
#'     identify an event-generating resource within the partner system.
#'     This should help AWS customers decide whether to create an event bus
#'     to receive these events.
#'
#' @usage
#' cloudwatchevents_create_partner_event_source(Name, Account)
#'
#' @param Name &#91;required&#93; The name of the partner event source. This name must be unique and must
#' be in the format
#' ` <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> `. The
#' AWS account that wants to use this partner event source must create a
#' partner event bus with a name that matches the name of the partner event
#' source.
#' @param Account &#91;required&#93; The AWS account ID of the customer who is permitted to create a matching
#' partner event bus for this partner event source.
#'
#' @section Request syntax:
#' ```
#' svc$create_partner_event_source(
#'   Name = "string",
#'   Account = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_create_partner_event_source
cloudwatchevents_create_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "CreatePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$create_partner_event_source_input(Name = Name, Account = Account)
  output <- .cloudwatchevents$create_partner_event_source_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$create_partner_event_source <- cloudwatchevents_create_partner_event_source

#' An AWS customer uses this operation to temporarily stop receiving events
#' from the specified partner event source
#'
#' An AWS customer uses this operation to temporarily stop receiving events
#' from the specified partner event source. The matching event bus isn\'t
#' deleted.
#' 
#' When you deactivate a partner event source, the source goes into
#' `PENDING` state. If it remains in `PENDING` state for more than two
#' weeks, it\'s deleted.
#' 
#' To activate a deactivated partner event source, use ActivateEventSource.
#'
#' @usage
#' cloudwatchevents_deactivate_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the partner event source to deactivate.
#'
#' @section Request syntax:
#' ```
#' svc$deactivate_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_deactivate_event_source
cloudwatchevents_deactivate_event_source <- function(Name) {
  op <- new_operation(
    name = "DeactivateEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$deactivate_event_source_input(Name = Name)
  output <- .cloudwatchevents$deactivate_event_source_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$deactivate_event_source <- cloudwatchevents_deactivate_event_source

#' Deletes the specified custom event bus or partner event bus
#'
#' Deletes the specified custom event bus or partner event bus. All rules
#' associated with this event bus are also deleted. You can\'t delete your
#' account\'s default event bus.
#' 
#' This operation is performed by AWS customers, not by SaaS partners.
#'
#' @usage
#' cloudwatchevents_delete_event_bus(Name)
#'
#' @param Name &#91;required&#93; The name of the event bus to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_bus(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_event_bus
cloudwatchevents_delete_event_bus <- function(Name) {
  op <- new_operation(
    name = "DeleteEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_event_bus_input(Name = Name)
  output <- .cloudwatchevents$delete_event_bus_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_event_bus <- cloudwatchevents_delete_event_bus

#' This operation is used by SaaS partners to delete a partner event source
#'
#' This operation is used by SaaS partners to delete a partner event
#' source. AWS customers don\'t use this operation.
#' 
#' When you delete an event source, the status of the corresponding partner
#' event bus in the AWS customer account becomes `DELETED`.
#'
#' @usage
#' cloudwatchevents_delete_partner_event_source(Name, Account)
#'
#' @param Name &#91;required&#93; The name of the event source to delete.
#' @param Account &#91;required&#93; The AWS account ID of the AWS customer that the event source was created
#' for.
#'
#' @section Request syntax:
#' ```
#' svc$delete_partner_event_source(
#'   Name = "string",
#'   Account = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_partner_event_source
cloudwatchevents_delete_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "DeletePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_partner_event_source_input(Name = Name, Account = Account)
  output <- .cloudwatchevents$delete_partner_event_source_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_partner_event_source <- cloudwatchevents_delete_partner_event_source

#' Deletes the specified rule
#'
#' Deletes the specified rule.
#' 
#' Before you can delete the rule, you must remove all targets, using
#' RemoveTargets.
#' 
#' When you delete a rule, incoming events might continue to match to the
#' deleted rule. Allow a short period of time for changes to take effect.
#' 
#' Managed rules are rules created and managed by another AWS service on
#' your behalf. These rules are created by those other AWS services to
#' support functionality in those services. You can delete these rules
#' using the `Force` option, but you should do so only if you\'re sure that
#' the other service isn\'t still using that rule.
#'
#' @usage
#' cloudwatchevents_delete_rule(Name, EventBusName, Force)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The event bus associated with the rule. If you omit this, the default
#' event bus is used.
#' @param Force If this is a managed rule, created by an AWS service on your behalf, you
#' must specify `Force` as `True` to delete the rule. This parameter is
#' ignored for rules that are not managed rules. You can check whether a
#' rule is a managed rule by using `DescribeRule` or `ListRules` and
#' checking the `ManagedBy` field of the response.
#'
#' @section Request syntax:
#' ```
#' svc$delete_rule(
#'   Name = "string",
#'   EventBusName = "string",
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_rule
cloudwatchevents_delete_rule <- function(Name, EventBusName = NULL, Force = NULL) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_rule_input(Name = Name, EventBusName = EventBusName, Force = Force)
  output <- .cloudwatchevents$delete_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_rule <- cloudwatchevents_delete_rule

#' Displays details about an event bus in your account
#'
#' Displays details about an event bus in your account. This can include
#' the external AWS accounts that are permitted to write events to your
#' default event bus, and the associated policy. For custom event buses and
#' partner event buses, it displays the name, ARN, policy, state, and
#' creation time.
#' 
#' To enable your account to receive events from other accounts on its
#' default event bus, use PutPermission.
#' 
#' For more information about partner event buses, see CreateEventBus.
#'
#' @usage
#' cloudwatchevents_describe_event_bus(Name)
#'
#' @param Name The name of the event bus to show details for. If you omit this, the
#' default event bus is displayed.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_bus(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_event_bus
cloudwatchevents_describe_event_bus <- function(Name = NULL) {
  op <- new_operation(
    name = "DescribeEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_event_bus_input(Name = Name)
  output <- .cloudwatchevents$describe_event_bus_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_event_bus <- cloudwatchevents_describe_event_bus

#' This operation lists details about a partner event source that is shared
#' with your account
#'
#' This operation lists details about a partner event source that is shared
#' with your account.
#' 
#' This operation is run by AWS customers, not by SaaS partners.
#'
#' @usage
#' cloudwatchevents_describe_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the partner event source to display the details of.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_event_source
cloudwatchevents_describe_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribeEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_event_source_input(Name = Name)
  output <- .cloudwatchevents$describe_event_source_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_event_source <- cloudwatchevents_describe_event_source

#' An SaaS partner can use this operation to list details about a partner
#' event source that they have created
#'
#' An SaaS partner can use this operation to list details about a partner
#' event source that they have created.
#' 
#' AWS customers do not use this operation. Instead, AWS customers can use
#' DescribeEventSource to see details about a partner event source that is
#' shared with them.
#'
#' @usage
#' cloudwatchevents_describe_partner_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the event source to display.
#'
#' @section Request syntax:
#' ```
#' svc$describe_partner_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_partner_event_source
cloudwatchevents_describe_partner_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_partner_event_source_input(Name = Name)
  output <- .cloudwatchevents$describe_partner_event_source_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_partner_event_source <- cloudwatchevents_describe_partner_event_source

#' Describes the specified rule
#'
#' Describes the specified rule.
#' 
#' `DescribeRule` doesn\'t list the targets of a rule. To see the targets
#' associated with a rule, use ListTargetsByRule.
#'
#' @usage
#' cloudwatchevents_describe_rule(Name, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The event bus associated with the rule. If you omit this, the default
#' event bus is used.
#'
#' @section Request syntax:
#' ```
#' svc$describe_rule(
#'   Name = "string",
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_rule
cloudwatchevents_describe_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DescribeRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .cloudwatchevents$describe_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_rule <- cloudwatchevents_describe_rule

#' Disables the specified rule
#'
#' Disables the specified rule. A disabled rule won\'t match any events and
#' won\'t self-trigger if it has a schedule expression.
#' 
#' When you disable a rule, incoming events might continue to match to the
#' disabled rule. Allow a short period of time for changes to take effect.
#'
#' @usage
#' cloudwatchevents_disable_rule(Name, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The event bus associated with the rule. If you omit this, the default
#' event bus is used.
#'
#' @section Request syntax:
#' ```
#' svc$disable_rule(
#'   Name = "string",
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_disable_rule
cloudwatchevents_disable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DisableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$disable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .cloudwatchevents$disable_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$disable_rule <- cloudwatchevents_disable_rule

#' Enables the specified rule
#'
#' Enables the specified rule. If the rule doesn\'t exist, the operation
#' fails.
#' 
#' When you enable a rule, incoming events might not immediately start
#' matching to a newly enabled rule. Allow a short period of time for
#' changes to take effect.
#'
#' @usage
#' cloudwatchevents_enable_rule(Name, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The event bus associated with the rule. If you omit this, the default
#' event bus is used.
#'
#' @section Request syntax:
#' ```
#' svc$enable_rule(
#'   Name = "string",
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_enable_rule
cloudwatchevents_enable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "EnableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$enable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .cloudwatchevents$enable_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$enable_rule <- cloudwatchevents_enable_rule

#' Lists all the event buses in your account, including the default event
#' bus, custom event buses, and partner event buses
#'
#' Lists all the event buses in your account, including the default event
#' bus, custom event buses, and partner event buses.
#' 
#' This operation is run by AWS customers, not by SaaS partners.
#'
#' @usage
#' cloudwatchevents_list_event_buses(NamePrefix, NextToken, Limit)
#'
#' @param NamePrefix Specifying this limits the results to only those event buses with names
#' that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a `NextToken` that you can use in a
#' subsequent operation to retrieve the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_event_buses(
#'   NamePrefix = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_event_buses
cloudwatchevents_list_event_buses <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventBuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_event_buses_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_event_buses_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_event_buses <- cloudwatchevents_list_event_buses

#' You can use this to see all the partner event sources that have been
#' shared with your AWS account
#'
#' You can use this to see all the partner event sources that have been
#' shared with your AWS account. For more information about partner event
#' sources, see CreateEventBus.
#' 
#' This operation is run by AWS customers, not by SaaS partners.
#'
#' @usage
#' cloudwatchevents_list_event_sources(NamePrefix, NextToken, Limit)
#'
#' @param NamePrefix Specifying this limits the results to only those partner event sources
#' with names that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a `NextToken` that you can use in a
#' subsequent operation to retrieve the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_event_sources(
#'   NamePrefix = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_event_sources
cloudwatchevents_list_event_sources <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_event_sources_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_event_sources <- cloudwatchevents_list_event_sources

#' An SaaS partner can use this operation to display the AWS account ID
#' that a particular partner event source name is associated with
#'
#' An SaaS partner can use this operation to display the AWS account ID
#' that a particular partner event source name is associated with.
#' 
#' This operation is used by SaaS partners, not by AWS customers.
#'
#' @usage
#' cloudwatchevents_list_partner_event_source_accounts(EventSourceName,
#'   NextToken, Limit)
#'
#' @param EventSourceName &#91;required&#93; The name of the partner event source to display account information
#' about.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a `NextToken` that you can use in a
#' subsequent operation to retrieve the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_partner_event_source_accounts(
#'   EventSourceName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_partner_event_source_accounts
cloudwatchevents_list_partner_event_source_accounts <- function(EventSourceName, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSourceAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_partner_event_source_accounts_input(EventSourceName = EventSourceName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_partner_event_source_accounts_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_partner_event_source_accounts <- cloudwatchevents_list_partner_event_source_accounts

#' An SaaS partner can use this operation to list all the partner event
#' source names that they have created
#'
#' An SaaS partner can use this operation to list all the partner event
#' source names that they have created.
#' 
#' This operation is not used by AWS customers.
#'
#' @usage
#' cloudwatchevents_list_partner_event_sources(NamePrefix, NextToken,
#'   Limit)
#'
#' @param NamePrefix &#91;required&#93; If you specify this, the results are limited to only those partner event
#' sources that start with the string you specify.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit pecifying this limits the number of results returned by this operation.
#' The operation also returns a `NextToken` that you can use in a
#' subsequent operation to retrieve the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_partner_event_sources(
#'   NamePrefix = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_partner_event_sources
cloudwatchevents_list_partner_event_sources <- function(NamePrefix, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_partner_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_partner_event_sources_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_partner_event_sources <- cloudwatchevents_list_partner_event_sources

#' Lists the rules for the specified target
#'
#' Lists the rules for the specified target. You can see which rules can
#' invoke a specific target in your account.
#'
#' @usage
#' cloudwatchevents_list_rule_names_by_target(TargetArn, EventBusName,
#'   NextToken, Limit)
#'
#' @param TargetArn &#91;required&#93; The Amazon Resource Name (ARN) of the target resource.
#' @param EventBusName Limits the results to show only the rules associated with the specified
#' event bus.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_rule_names_by_target(
#'   TargetArn = "string",
#'   EventBusName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_rule_names_by_target
cloudwatchevents_list_rule_names_by_target <- function(TargetArn, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleNamesByTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_rule_names_by_target_input(TargetArn = TargetArn, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_rule_names_by_target_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_rule_names_by_target <- cloudwatchevents_list_rule_names_by_target

#' Lists your EventBridge rules
#'
#' Lists your EventBridge rules. You can either list all the rules or
#' provide a prefix to match to the rule names.
#' 
#' `ListRules` doesn\'t list the targets of a rule. To see the targets
#' associated with a rule, use ListTargetsByRule.
#'
#' @usage
#' cloudwatchevents_list_rules(NamePrefix, EventBusName, NextToken, Limit)
#'
#' @param NamePrefix The prefix matching the rule name.
#' @param EventBusName Limits the results to show only the rules associated with the specified
#' event bus.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_rules(
#'   NamePrefix = "string",
#'   EventBusName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_rules
cloudwatchevents_list_rules <- function(NamePrefix = NULL, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_rules_input(NamePrefix = NamePrefix, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_rules_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_rules <- cloudwatchevents_list_rules

#' Displays the tags associated with an EventBridge resource
#'
#' Displays the tags associated with an EventBridge resource. In
#' EventBridge, rules can be tagged.
#'
#' @usage
#' cloudwatchevents_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the rule for which you want to view tags.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_tags_for_resource
cloudwatchevents_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .cloudwatchevents$list_tags_for_resource_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_tags_for_resource <- cloudwatchevents_list_tags_for_resource

#' Lists the targets assigned to the specified rule
#'
#' Lists the targets assigned to the specified rule.
#'
#' @usage
#' cloudwatchevents_list_targets_by_rule(Rule, EventBusName, NextToken,
#'   Limit)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The event bus associated with the rule. If you omit this, the default
#' event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_targets_by_rule(
#'   Rule = "string",
#'   EventBusName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_targets_by_rule
cloudwatchevents_list_targets_by_rule <- function(Rule, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTargetsByRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_targets_by_rule_input(Rule = Rule, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_targets_by_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_targets_by_rule <- cloudwatchevents_list_targets_by_rule

#' Sends custom events to EventBridge so that they can be matched to rules
#'
#' Sends custom events to EventBridge so that they can be matched to rules.
#' These events can be from your custom applications and services.
#'
#' @usage
#' cloudwatchevents_put_events(Entries)
#'
#' @param Entries &#91;required&#93; The entry that defines an event in your system. You can specify several
#' parameters for the entry such as the source and type of the event,
#' resources associated with the event, and so on.
#'
#' @section Request syntax:
#' ```
#' svc$put_events(
#'   Entries = list(
#'     list(
#'       Time = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Source = "string",
#'       Resources = list(
#'         "string"
#'       ),
#'       DetailType = "string",
#'       Detail = "string",
#'       EventBusName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_events
cloudwatchevents_put_events <- function(Entries) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_events_input(Entries = Entries)
  output <- .cloudwatchevents$put_events_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_events <- cloudwatchevents_put_events

#' This is used by SaaS partners to write events to a customer's partner
#' event bus
#'
#' This is used by SaaS partners to write events to a customer\'s partner
#' event bus.
#' 
#' AWS customers do not use this operation. Instead, AWS customers can use
#' PutEvents to write custom events from their own applications to an event
#' bus.
#'
#' @usage
#' cloudwatchevents_put_partner_events(Entries)
#'
#' @param Entries &#91;required&#93; The list of events to write to the event bus.
#'
#' @section Request syntax:
#' ```
#' svc$put_partner_events(
#'   Entries = list(
#'     list(
#'       Time = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Source = "string",
#'       Resources = list(
#'         "string"
#'       ),
#'       DetailType = "string",
#'       Detail = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_partner_events
cloudwatchevents_put_partner_events <- function(Entries) {
  op <- new_operation(
    name = "PutPartnerEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_partner_events_input(Entries = Entries)
  output <- .cloudwatchevents$put_partner_events_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_partner_events <- cloudwatchevents_put_partner_events

#' Running PutPermission permits the specified AWS account or AWS
#' organization to put events to the specified _event bus_
#'
#' Running `PutPermission` permits the specified AWS account or AWS
#' organization to put events to the specified *event bus*. Rules in your
#' account are triggered by these events arriving to an event bus in your
#' account.
#' 
#' For another account to send events to your account, that external
#' account must have a rule with your account\'s event bus as a target.
#' 
#' To enable multiple AWS accounts to put events to an event bus, run
#' `PutPermission` once for each of these accounts. Or, if all the accounts
#' are members of the same AWS organization, you can run `PutPermission`
#' once specifying `Principal` as \"\*\" and specifying the AWS
#' organization ID in `Condition`, to grant permissions to all accounts in
#' that organization.
#' 
#' If you grant permissions using an organization, then accounts in that
#' organization must specify a `RoleArn` with proper permissions when they
#' use `PutTarget` to add your account\'s event bus as a target. For more
#' information, see [Sending and Receiving Events Between AWS
#' Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html)
#' in the *Amazon EventBridge User Guide*.
#' 
#' The permission policy on an event bus can\'t exceed 10 KB in size.
#'
#' @usage
#' cloudwatchevents_put_permission(EventBusName, Action, Principal,
#'   StatementId, Condition)
#'
#' @param EventBusName The event bus associated with the rule. If you omit this, the default
#' event bus is used.
#' @param Action &#91;required&#93; The action that you\'re enabling the other account to perform.
#' Currently, this must be `events:PutEvents`.
#' @param Principal &#91;required&#93; The 12-digit AWS account ID that you are permitting to put events to
#' your default event bus. Specify \"\*\" to permit any account to put
#' events to your default event bus.
#' 
#' If you specify \"\*\" without specifying `Condition`, avoid creating
#' rules that might match undesirable events. To create more secure rules,
#' make sure that the event pattern for each rule contains an `account`
#' field with a specific account ID to receive events from. Rules with an
#' account field don\'t match any events sent from other accounts.
#' @param StatementId &#91;required&#93; An identifier string for the external account that you\'re granting
#' permissions to. If you later want to revoke the permission for this
#' external account, specify this `StatementId` when you run
#' RemovePermission.
#' @param Condition This parameter enables you to limit the permission to accounts that
#' fulfill a certain condition, such as being a member of a certain AWS
#' organization. For more information about AWS Organizations, see [What Is
#' AWS
#' Organizations?](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)
#' in the *AWS Organizations User Guide*.
#' 
#' If you specify `Condition` with an AWS organization ID and specify
#' \"\*\" as the value for `Principal`, you grant permission to all the
#' accounts in the named organization.
#' 
#' The `Condition` is a JSON string that must contain `Type`, `Key`, and
#' `Value` fields.
#'
#' @section Request syntax:
#' ```
#' svc$put_permission(
#'   EventBusName = "string",
#'   Action = "string",
#'   Principal = "string",
#'   StatementId = "string",
#'   Condition = list(
#'     Type = "string",
#'     Key = "string",
#'     Value = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_permission
cloudwatchevents_put_permission <- function(EventBusName = NULL, Action, Principal, StatementId, Condition = NULL) {
  op <- new_operation(
    name = "PutPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_permission_input(EventBusName = EventBusName, Action = Action, Principal = Principal, StatementId = StatementId, Condition = Condition)
  output <- .cloudwatchevents$put_permission_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_permission <- cloudwatchevents_put_permission

#' Creates or updates the specified rule
#'
#' Creates or updates the specified rule. Rules are enabled by default or
#' based on value of the state. You can disable a rule using DisableRule.
#' 
#' A single rule watches for events from a single event bus. Events
#' generated by AWS services go to your account\'s default event bus.
#' Events generated by SaaS partner services or applications go to the
#' matching partner event bus. If you have custom applications or services,
#' you can specify whether their events go to your default event bus or a
#' custom event bus that you have created. For more information, see
#' CreateEventBus.
#' 
#' If you\'re updating an existing rule, the rule is replaced with what you
#' specify in this `PutRule` command. If you omit arguments in `PutRule`,
#' the old values for those arguments aren\'t kept. Instead, they\'re
#' replaced with null values.
#' 
#' When you create or update a rule, incoming events might not immediately
#' start matching to new or updated rules. Allow a short period of time for
#' changes to take effect.
#' 
#' A rule must contain at least an `EventPattern` or `ScheduleExpression`.
#' Rules with `EventPatterns` are triggered when a matching event is
#' observed. Rules with `ScheduleExpressions` self-trigger based on the
#' given schedule. A rule can have both an `EventPattern` and a
#' `ScheduleExpression`, in which case the rule triggers on matching events
#' as well as on a schedule.
#' 
#' When you initially create a rule, you can optionally assign one or more
#' tags to the rule. Tags can help you organize and categorize your
#' resources. You can also use them to scope user permissions, by granting
#' a user permission to access or change only rules with certain tag
#' values. To use the `PutRule` operation and assign tags, you must have
#' both the `events:PutRule` and `events:TagResource` permissions.
#' 
#' If you are updating an existing rule, any tags you specify in the
#' `PutRule` operation are ignored. To update the tags of an existing rule,
#' use TagResource and UntagResource.
#' 
#' Most services in AWS treat `:` or `/` as the same character in Amazon
#' Resource Names (ARNs). However, EventBridge uses an exact match in event
#' patterns and rules. Be sure to use the correct ARN characters when
#' creating event patterns so that they match the ARN syntax in the event
#' that you want to match.
#' 
#' In EventBridge, you could create rules that lead to infinite loops,
#' where a rule is fired repeatedly. For example, a rule might detect that
#' ACLs have changed on an S3 bucket, and trigger software to change them
#' to the desired state. If you don\'t write the rule carefully, the
#' subsequent change to the ACLs fires the rule again, creating an infinite
#' loop.
#' 
#' To prevent this, write the rules so that the triggered actions don\'t
#' refire the same rule. For example, your rule could fire only if ACLs are
#' found to be in a bad state, instead of after any change.
#' 
#' An infinite loop can quickly cause higher than expected charges. We
#' recommend that you use budgeting, which alerts you when charges exceed
#' your specified limit. For more information, see [Managing Your Costs
#' with
#' Budgets](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html).
#'
#' @usage
#' cloudwatchevents_put_rule(Name, ScheduleExpression, EventPattern, State,
#'   Description, RoleArn, Tags, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule that you\'re creating or updating.
#' @param ScheduleExpression The scheduling expression: for example, `"cron(0 20 * * ? *)"` or
#' `"rate(5 minutes)"`.
#' @param EventPattern The event pattern. For more information, see [Event
#' Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
#' in the *Amazon EventBridge User Guide*.
#' @param State Indicates whether the rule is enabled or disabled.
#' @param Description A description of the rule.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role associated with the rule.
#' @param Tags The list of key-value pairs to associate with the rule.
#' @param EventBusName The event bus to associate with this rule. If you omit this, the default
#' event bus is used.
#'
#' @section Request syntax:
#' ```
#' svc$put_rule(
#'   Name = "string",
#'   ScheduleExpression = "string",
#'   EventPattern = "string",
#'   State = "ENABLED"|"DISABLED",
#'   Description = "string",
#'   RoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_rule
cloudwatchevents_put_rule <- function(Name, ScheduleExpression = NULL, EventPattern = NULL, State = NULL, Description = NULL, RoleArn = NULL, Tags = NULL, EventBusName = NULL) {
  op <- new_operation(
    name = "PutRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_rule_input(Name = Name, ScheduleExpression = ScheduleExpression, EventPattern = EventPattern, State = State, Description = Description, RoleArn = RoleArn, Tags = Tags, EventBusName = EventBusName)
  output <- .cloudwatchevents$put_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_rule <- cloudwatchevents_put_rule

#' Adds the specified targets to the specified rule, or updates the targets
#' if they're already associated with the rule
#'
#' Adds the specified targets to the specified rule, or updates the targets
#' if they\'re already associated with the rule.
#' 
#' Targets are the resources that are invoked when a rule is triggered.
#' 
#' You can configure the following as targets in EventBridge:
#' 
#' -   EC2 instances
#' 
#' -   SSM Run Command
#' 
#' -   SSM Automation
#' 
#' -   AWS Lambda functions
#' 
#' -   Data streams in Amazon Kinesis Data Streams
#' 
#' -   Data delivery streams in Amazon Kinesis Data Firehose
#' 
#' -   Amazon ECS tasks
#' 
#' -   AWS Step Functions state machines
#' 
#' -   AWS Batch jobs
#' 
#' -   AWS CodeBuild projects
#' 
#' -   Pipelines in AWS CodePipeline
#' 
#' -   Amazon Inspector assessment templates
#' 
#' -   Amazon SNS topics
#' 
#' -   Amazon SQS queues, including FIFO queues
#' 
#' -   The default event bus of another AWS account
#' 
#' Creating rules with built-in targets is supported only on the AWS
#' Management Console. The built-in targets are
#' `EC2 CreateSnapshot API call`, `EC2 RebootInstances API call`,
#' `EC2 StopInstances API call`, and `EC2 TerminateInstances API call`.
#' 
#' For some target types, `PutTargets` provides target-specific parameters.
#' If the target is a Kinesis data stream, you can optionally specify which
#' shard the event goes to by using the `KinesisParameters` argument. To
#' invoke a command on multiple EC2 instances with one rule, you can use
#' the `RunCommandParameters` field.
#' 
#' To be able to make API calls against the resources that you own, Amazon
#' EventBridge needs the appropriate permissions. For AWS Lambda and Amazon
#' SNS resources, EventBridge relies on resource-based policies. For EC2
#' instances, Kinesis data streams, and AWS Step Functions state machines,
#' EventBridge relies on IAM roles that you specify in the `RoleARN`
#' argument in `PutTargets`. For more information, see [Authentication and
#' Access
#' Control](https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html)
#' in the *Amazon EventBridge User Guide*.
#' 
#' If another AWS account is in the same Region and has granted you
#' permission (using `PutPermission`), you can send events to that account.
#' Set that account\'s event bus as a target of the rules in your account.
#' To send the matched events to the other account, specify that account\'s
#' event bus as the `Arn` value when you run `PutTargets`. If your account
#' sends events to another account, your account is charged for each sent
#' event. Each event sent to another account is charged as a custom event.
#' The account receiving the event isn\'t charged. For more information,
#' see [Amazon EventBridge
#' Pricing](https://aws.amazon.com/eventbridge/pricing/).
#' 
#' If you\'re setting an event bus in another account as the target and
#' that account granted permission to your account through an organization
#' instead of directly by the account ID, you must specify a `RoleArn` with
#' proper permissions in the `Target` structure. For more information, see
#' [Sending and Receiving Events Between AWS
#' Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html)
#' in the *Amazon EventBridge User Guide*.
#' 
#' For more information about enabling cross-account events, see
#' PutPermission.
#' 
#' `Input`, `InputPath`, and `InputTransformer` are mutually exclusive and
#' optional parameters of a target. When a rule is triggered due to a
#' matched event:
#' 
#' -   If none of the following arguments are specified for a target, the
#'     entire event is passed to the target in JSON format (unless the
#'     target is Amazon EC2 Run Command or Amazon ECS task, in which case
#'     nothing from the event is passed to the target).
#' 
#' -   If `Input` is specified in the form of valid JSON, then the matched
#'     event is overridden with this constant.
#' 
#' -   If `InputPath` is specified in the form of JSONPath (for example,
#'     `$.detail`), only the part of the event specified in the path is
#'     passed to the target (for example, only the detail part of the event
#'     is passed).
#' 
#' -   If `InputTransformer` is specified, one or more specified JSONPaths
#'     are extracted from the event and used as values in a template that
#'     you specify as the input to the target.
#' 
#' When you specify `InputPath` or `InputTransformer`, you must use JSON
#' dot notation, not bracket notation.
#' 
#' When you add targets to a rule and the associated rule triggers soon
#' after, new or updated targets might not be immediately invoked. Allow a
#' short period of time for changes to take effect.
#' 
#' This action can partially fail if too many requests are made at the same
#' time. If that happens, `FailedEntryCount` is nonzero in the response,
#' and each entry in `FailedEntries` provides the ID of the failed target
#' and the error code.
#'
#' @usage
#' cloudwatchevents_put_targets(Rule, EventBusName, Targets)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name of the event bus associated with the rule. If you omit this,
#' the default event bus is used.
#' @param Targets &#91;required&#93; The targets to update or add to the rule.
#'
#' @section Request syntax:
#' ```
#' svc$put_targets(
#'   Rule = "string",
#'   EventBusName = "string",
#'   Targets = list(
#'     list(
#'       Id = "string",
#'       Arn = "string",
#'       RoleArn = "string",
#'       Input = "string",
#'       InputPath = "string",
#'       InputTransformer = list(
#'         InputPathsMap = list(
#'           "string"
#'         ),
#'         InputTemplate = "string"
#'       ),
#'       KinesisParameters = list(
#'         PartitionKeyPath = "string"
#'       ),
#'       RunCommandParameters = list(
#'         RunCommandTargets = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       EcsParameters = list(
#'         TaskDefinitionArn = "string",
#'         TaskCount = 123,
#'         LaunchType = "EC2"|"FARGATE",
#'         NetworkConfiguration = list(
#'           awsvpcConfiguration = list(
#'             Subnets = list(
#'               "string"
#'             ),
#'             SecurityGroups = list(
#'               "string"
#'             ),
#'             AssignPublicIp = "ENABLED"|"DISABLED"
#'           )
#'         ),
#'         PlatformVersion = "string",
#'         Group = "string"
#'       ),
#'       BatchParameters = list(
#'         JobDefinition = "string",
#'         JobName = "string",
#'         ArrayProperties = list(
#'           Size = 123
#'         ),
#'         RetryStrategy = list(
#'           Attempts = 123
#'         )
#'       ),
#'       SqsParameters = list(
#'         MessageGroupId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_targets
cloudwatchevents_put_targets <- function(Rule, EventBusName = NULL, Targets) {
  op <- new_operation(
    name = "PutTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_targets_input(Rule = Rule, EventBusName = EventBusName, Targets = Targets)
  output <- .cloudwatchevents$put_targets_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_targets <- cloudwatchevents_put_targets

#' Revokes the permission of another AWS account to be able to put events
#' to the specified event bus
#'
#' Revokes the permission of another AWS account to be able to put events
#' to the specified event bus. Specify the account to revoke by the
#' `StatementId` value that you associated with the account when you
#' granted it permission with `PutPermission`. You can find the
#' `StatementId` by using DescribeEventBus.
#'
#' @usage
#' cloudwatchevents_remove_permission(StatementId, EventBusName)
#'
#' @param StatementId &#91;required&#93; The statement ID corresponding to the account that is no longer allowed
#' to put events to the default event bus.
#' @param EventBusName The name of the event bus to revoke permissions for. If you omit this,
#' the default event bus is used.
#'
#' @section Request syntax:
#' ```
#' svc$remove_permission(
#'   StatementId = "string",
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_remove_permission
cloudwatchevents_remove_permission <- function(StatementId, EventBusName = NULL) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$remove_permission_input(StatementId = StatementId, EventBusName = EventBusName)
  output <- .cloudwatchevents$remove_permission_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$remove_permission <- cloudwatchevents_remove_permission

#' Removes the specified targets from the specified rule
#'
#' Removes the specified targets from the specified rule. When the rule is
#' triggered, those targets are no longer be invoked.
#' 
#' When you remove a target, when the associated rule triggers, removed
#' targets might continue to be invoked. Allow a short period of time for
#' changes to take effect.
#' 
#' This action can partially fail if too many requests are made at the same
#' time. If that happens, `FailedEntryCount` is non-zero in the response
#' and each entry in `FailedEntries` provides the ID of the failed target
#' and the error code.
#'
#' @usage
#' cloudwatchevents_remove_targets(Rule, EventBusName, Ids, Force)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name of the event bus associated with the rule.
#' @param Ids &#91;required&#93; The IDs of the targets to remove from the rule.
#' @param Force If this is a managed rule created by an AWS service on your behalf, you
#' must specify `Force` as `True` to remove targets. This parameter is
#' ignored for rules that aren\'t managed rules. You can check whether a
#' rule is a managed rule by using `DescribeRule` or `ListRules` and
#' checking the `ManagedBy` field of the response.
#'
#' @section Request syntax:
#' ```
#' svc$remove_targets(
#'   Rule = "string",
#'   EventBusName = "string",
#'   Ids = list(
#'     "string"
#'   ),
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_remove_targets
cloudwatchevents_remove_targets <- function(Rule, EventBusName = NULL, Ids, Force = NULL) {
  op <- new_operation(
    name = "RemoveTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$remove_targets_input(Rule = Rule, EventBusName = EventBusName, Ids = Ids, Force = Force)
  output <- .cloudwatchevents$remove_targets_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$remove_targets <- cloudwatchevents_remove_targets

#' Assigns one or more tags (key-value pairs) to the specified EventBridge
#' resource
#'
#' Assigns one or more tags (key-value pairs) to the specified EventBridge
#' resource. Tags can help you organize and categorize your resources. You
#' can also use them to scope user permissions by granting a user
#' permission to access or change only resources with certain tag values.
#' In EventBridge, rules can be tagged.
#' 
#' Tags don\'t have any semantic meaning to AWS and are interpreted
#' strictly as strings of characters.
#' 
#' You can use the `TagResource` action with a rule that already has tags.
#' If you specify a new tag key for the rule, this tag is appended to the
#' list of tags associated with the rule. If you specify a tag key that is
#' already associated with the rule, the new tag value that you specify
#' replaces the previous value for that tag.
#' 
#' You can associate as many as 50 tags with a resource.
#'
#' @usage
#' cloudwatchevents_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the rule that you\'re adding tags to.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the rule.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_tag_resource
cloudwatchevents_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .cloudwatchevents$tag_resource_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$tag_resource <- cloudwatchevents_tag_resource

#' Tests whether the specified event pattern matches the provided event
#'
#' Tests whether the specified event pattern matches the provided event.
#' 
#' Most services in AWS treat `:` or `/` as the same character in Amazon
#' Resource Names (ARNs). However, EventBridge uses an exact match in event
#' patterns and rules. Be sure to use the correct ARN characters when
#' creating event patterns so that they match the ARN syntax in the event
#' that you want to match.
#'
#' @usage
#' cloudwatchevents_test_event_pattern(EventPattern, Event)
#'
#' @param EventPattern &#91;required&#93; The event pattern. For more information, see [Event
#' Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
#' in the *Amazon EventBridge User Guide*.
#' @param Event &#91;required&#93; The event, in JSON format, to test against the event pattern.
#'
#' @section Request syntax:
#' ```
#' svc$test_event_pattern(
#'   EventPattern = "string",
#'   Event = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_test_event_pattern
cloudwatchevents_test_event_pattern <- function(EventPattern, Event) {
  op <- new_operation(
    name = "TestEventPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$test_event_pattern_input(EventPattern = EventPattern, Event = Event)
  output <- .cloudwatchevents$test_event_pattern_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$test_event_pattern <- cloudwatchevents_test_event_pattern

#' Removes one or more tags from the specified EventBridge resource
#'
#' Removes one or more tags from the specified EventBridge resource. In
#' EventBridge, rules can be tagged.
#'
#' @usage
#' cloudwatchevents_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the rule that you\'re removing tags from.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_untag_resource
cloudwatchevents_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .cloudwatchevents$untag_resource_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$untag_resource <- cloudwatchevents_untag_resource
