% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_detach_load_balancers}
\alias{autoscaling_detach_load_balancers}
\title{Detaches one or more Classic Load Balancers from the specified Auto
Scaling group}
\usage{
autoscaling_detach_load_balancers(AutoScalingGroupName,
  LoadBalancerNames)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LoadBalancerNames}{[required] The names of the load balancers. You can specify up to 10 load
balancers.}
}
\description{
Detaches one or more Classic Load Balancers from the specified Auto
Scaling group.
}
\details{
This operation detaches only Classic Load Balancers. If you have
Application Load Balancers or Network Load Balancers, use
DetachLoadBalancerTargetGroups instead.

When you detach a load balancer, it enters the \code{Removing} state while
deregistering the instances in the group. When all instances are
deregistered, then you can no longer describe the load balancer using
DescribeLoadBalancers. The instances remain running.
}
\section{Request syntax}{
\preformatted{svc$detach_load_balancers(
  AutoScalingGroupName = "string",
  LoadBalancerNames = list(
    "string"
  )
)
}
}

\examples{
# This example detaches the specified load balancer from the specified
# Auto Scaling group.
\donttest{svc$detach_load_balancers(
  AutoScalingGroupName = "my-auto-scaling-group",
  LoadBalancerNames = list(
    "my-load-balancer"
  )
)}

}
\keyword{internal}
