% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_lookup_events}
\alias{cloudtrail_lookup_events}
\title{Looks up management events captured by CloudTrail}
\usage{
cloudtrail_lookup_events(LookupAttributes, StartTime, EndTime,
  MaxResults, NextToken)
}
\arguments{
\item{LookupAttributes}{Contains a list of lookup attributes. Currently the list can contain
only one item.}

\item{StartTime}{Specifies that only events that occur after or at the specified time are
returned. If the specified start time is after the specified end time,
an error is returned.}

\item{EndTime}{Specifies that only events that occur before or at the specified time
are returned. If the specified end time is before the specified start
time, an error is returned.}

\item{MaxResults}{The number of events to return. Possible values are 1 through 50. The
default is 50.}

\item{NextToken}{The token to use to get the next page of results after a previous API
call. This token must be passed in with the same parameters that were
specified in the the original call. For example, if the original call
specified an AttributeKey of 'Username' with a value of 'root', the
call with NextToken should include those same parameters.}
}
\description{
Looks up \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events}{management events}
captured by CloudTrail. Events for a region can be looked up in that
region during the last 90 days. Lookup supports the following
attributes:
}
\details{
\itemize{
\item AWS access key
\item Event ID
\item Event name
\item Event source
\item Read only
\item Resource name
\item Resource type
\item User name
}

All attributes are optional. The default number of results returned is
50, with a maximum of 50 possible. The response includes a token that
you can use to get the next page of results.

The rate of lookup requests is limited to one per second per account. If
this limit is exceeded, a throttling error occurs.

Events that occurred during the selected time range will not be
available for lookup if CloudTrail logging was not enabled when the
events occurred.
}
\section{Request syntax}{
\preformatted{svc$lookup_events(
  LookupAttributes = list(
    list(
      AttributeKey = "EventId"|"EventName"|"ReadOnly"|"Username"|"ResourceType"|"ResourceName"|"EventSource"|"AccessKeyId",
      AttributeValue = "string"
    )
  ),
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
