% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_create_backup}
\alias{opsworkscm_create_backup}
\title{Creates an application-level backup of a server}
\usage{
opsworkscm_create_backup(ServerName, Description)
}
\arguments{
\item{ServerName}{[required] The name of the server that you want to back up.}

\item{Description}{A user-defined description of the backup.}
}
\description{
Creates an application-level backup of a server. While the server is in
the \code{BACKING_UP} state, the server cannot be changed, and no additional
backup can be created.
}
\details{
Backups can be created for servers in \code{RUNNING}, \code{HEALTHY}, and
\code{UNHEALTHY} states. By default, you can create a maximum of 50 manual
backups.

This operation is asynchronous.

A \code{LimitExceededException} is thrown when the maximum number of manual
backups is reached. An \code{InvalidStateException} is thrown when the server
is not in any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A
\code{ResourceNotFoundException} is thrown when the server is not found. A
\code{ValidationException} is thrown when parameters of the request are not
valid.
}
\section{Request syntax}{
\preformatted{svc$create_backup(
  ServerName = "string",
  Description = "string"
)
}
}

\keyword{internal}
