% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroupstaggingapi_operations.R
\name{resourcegroupstaggingapi_tag_resources}
\alias{resourcegroupstaggingapi_tag_resources}
\title{Applies one or more tags to the specified resources}
\usage{
resourcegroupstaggingapi_tag_resources(ResourceARNList, Tags)
}
\arguments{
\item{ResourceARNList}{[required] A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a
resource. You can specify a minimum of 1 and a maximum of 20 ARNs
(resources) to tag. An ARN can be set to a maximum of 1600 characters.
For more information, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{Tags}{[required] The tags that you want to add to the specified resources. A tag consists
of a key and a value that you define.}
}
\description{
Applies one or more tags to the specified resources. Note the following:
}
\details{
\itemize{
\item Not all resources can have tags. For a list of resources that
support tagging, see \href{http://docs.aws.amazon.com/ARG/latest/userguide/supported-resources.html}{Supported Resources}
in the \emph{AWS Resource Groups User Guide}.
\item Each resource can have up to 50 tags. For other limits, see \href{http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-restrictions}{Tag Restrictions}
in the \emph{Amazon EC2 User Guide for Linux Instances}.
\item You can only tag resources that are located in the specified region
for the AWS account.
\item To add tags to a resource, you need the necessary permissions for
the service that the resource belongs to as well as permissions for
adding tags. For more information, see \href{http://docs.aws.amazon.com/ARG/latest/userguide/obtaining-permissions-for-tagging.html}{Obtaining Permissions for Tagging}
in the \emph{AWS Resource Groups User Guide}.
}
}
\section{Request syntax}{
\preformatted{svc$tag_resources(
  ResourceARNList = list(
    "string"
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
