% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_create_case}
\alias{support_create_case}
\title{Creates a new case in the AWS Support Center}
\usage{
support_create_case(subject, serviceCode, severityCode, categoryCode,
  communicationBody, ccEmailAddresses, language, issueType,
  attachmentSetId)
}
\arguments{
\item{subject}{[required] The title of the AWS Support case.}

\item{serviceCode}{The code for the AWS service returned by the call to DescribeServices.}

\item{severityCode}{The code for the severity level returned by the call to
DescribeSeverityLevels.

The availability of severity levels depends on each customer's support
subscription. In other words, your subscription may not necessarily
require the urgent level of response time.}

\item{categoryCode}{The category of problem for the AWS Support case.}

\item{communicationBody}{[required] The communication body text when you create an AWS Support case by
calling CreateCase.}

\item{ccEmailAddresses}{A list of email addresses that AWS Support copies on case
correspondence.}

\item{language}{The ISO 639-1 code for the language in which AWS provides support. AWS
Support currently supports English ("en") and Japanese ("ja").
Language parameters must be passed explicitly for operations that take
them.}

\item{issueType}{The type of issue for the case. You can specify either
"customer-service" or "technical." If you do not indicate a value,
the default is "technical."}

\item{attachmentSetId}{The ID of a set of one or more attachments for the case. Create the set
by using AddAttachmentsToSet.}
}
\description{
Creates a new case in the AWS Support Center. This operation is modeled
on the behavior of the AWS Support Center \href{https://console.aws.amazon.com/support/home#/case/create}{Create Case} page.
Its parameters require you to specify the following information:
}
\details{
\itemize{
\item \strong{issueType.} The type of issue for the case. You can specify
either "customer-service" or "technical." If you do not indicate
a value, the default is "technical."
\item \strong{serviceCode.} The code for an AWS service. You obtain the
\code{serviceCode} by calling DescribeServices.
\item \strong{categoryCode.} The category for the service defined for the
\code{serviceCode} value. You also obtain the category code for a service
by calling DescribeServices. Each AWS service defines its own set of
category codes.
\item \strong{severityCode.} A value that indicates the urgency of the case,
which in turn determines the response time according to your service
level agreement with AWS Support. You obtain the SeverityCode by
calling DescribeSeverityLevels.
\item \strong{subject.} The \strong{Subject} field on the AWS Support Center \href{https://console.aws.amazon.com/support/home#/case/create}{Create Case}
page.
\item \strong{communicationBody.} The \strong{Description} field on the AWS Support
Center \href{https://console.aws.amazon.com/support/home#/case/create}{Create Case}
page.
\item \strong{attachmentSetId.} The ID of a set of attachments that has been
created by using AddAttachmentsToSet.
\item \strong{language.} The human language in which AWS Support handles the
case. English and Japanese are currently supported.
\item \strong{ccEmailAddresses.} The AWS Support Center \strong{CC} field on the
\href{https://console.aws.amazon.com/support/home#/case/create}{Create Case}
page. You can list email addresses to be copied on any
correspondence about the case. The account that opens the case is
already identified by passing the AWS Credentials in the HTTP POST
method or in a method or function call from one of the programming
languages supported by an \href{http://aws.amazon.com/tools/}{AWS SDK}.
}

To add additional communication or attachments to an existing case, use
AddCommunicationToCase.

A successful CreateCase request returns an AWS Support case number. Case
numbers are used by the DescribeCases operation to retrieve existing AWS
Support cases.
}
\section{Request syntax}{
\preformatted{svc$create_case(
  subject = "string",
  serviceCode = "string",
  severityCode = "string",
  categoryCode = "string",
  communicationBody = "string",
  ccEmailAddresses = list(
    "string"
  ),
  language = "string",
  issueType = "string",
  attachmentSetId = "string"
)
}
}

\keyword{internal}
