% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_update_license_specifications_for_resource}
\alias{licensemanager_update_license_specifications_for_resource}
\title{Adds or removes license configurations for a specified AWS resource}
\usage{
licensemanager_update_license_specifications_for_resource(ResourceArn,
  AddLicenseSpecifications, RemoveLicenseSpecifications)
}
\arguments{
\item{ResourceArn}{[required] ARN for an AWS server resource.}

\item{AddLicenseSpecifications}{License configuration ARNs to be added to a resource.}

\item{RemoveLicenseSpecifications}{License configuration ARNs to be removed from a resource.}
}
\description{
Adds or removes license configurations for a specified AWS resource.
This operation currently supports updating the license specifications of
AMIs, instances, and hosts. Launch templates and AWS CloudFormation
templates are not managed from this operation as those resources send
the license configurations directly to a resource creation operation,
such as \code{RunInstances}.
}
\section{Request syntax}{
\preformatted{svc$update_license_specifications_for_resource(
  ResourceArn = "string",
  AddLicenseSpecifications = list(
    list(
      LicenseConfigurationArn = "string"
    )
  ),
  RemoveLicenseSpecifications = list(
    list(
      LicenseConfigurationArn = "string"
    )
  )
)
}
}

\keyword{internal}
