% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_notification_configuration}
\alias{autoscaling_put_notification_configuration}
\title{Configures an Auto Scaling group to send notifications when specified
events take place}
\usage{
autoscaling_put_notification_configuration(AutoScalingGroupName,
  TopicARN, NotificationTypes)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{TopicARN}{[required] The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
(Amazon SNS) topic.}

\item{NotificationTypes}{[required] The type of event that causes the notification to be sent. For more
information about notification types supported by Amazon EC2 Auto
Scaling, see DescribeAutoScalingNotificationTypes.}
}
\description{
Configures an Auto Scaling group to send notifications when specified
events take place. Subscribers to the specified topic can have messages
delivered to an endpoint such as a web server or an email address.
}
\details{
This configuration overwrites any existing configuration.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html}{Getting Amazon SNS Notifications When Your Auto Scaling Group Scales}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_notification_configuration(
  AutoScalingGroupName = "string",
  TopicARN = "string",
  NotificationTypes = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example adds the specified notification to the specified Auto
# Scaling group.
svc$put_notification_configuration(
  AutoScalingGroupName = "my-auto-scaling-group",
  NotificationTypes = list(
    "autoscaling:TEST_NOTIFICATION"
  ),
  TopicARN = "arn:aws:sns:us-west-2:123456789012:my-sns-topic"
)
}

}
\keyword{internal}
