% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_usage_for_license_configuration}
\alias{licensemanager_list_usage_for_license_configuration}
\title{Lists all license usage records for a license configuration, displaying
license consumption details by resource at a selected point in time}
\usage{
licensemanager_list_usage_for_license_configuration(
  LicenseConfigurationArn, MaxResults, NextToken, Filters)
}
\arguments{
\item{LicenseConfigurationArn}{[required] Amazon Resource Name (ARN) of the license configuration.}

\item{MaxResults}{Maximum number of results to return in a single call.}

\item{NextToken}{Token for the next set of results.}

\item{Filters}{Filters to scope the results. The following filters and logical
operators are supported:
\itemize{
\item \code{resourceArn} - The ARN of the license configuration resource.
Logical operators are \code{EQUALS} \\| \code{NOT_EQUALS}.
\item \code{resourceType} - The resource type (EC2\\_INSTANCE \\| EC2\\_HOST \\|
EC2\\_AMI \\| SYSTEMS\\_MANAGER\\_MANAGED\\_INSTANCE). Logical operators
are \code{EQUALS} \\| \code{NOT_EQUALS}.
\item \code{resourceAccount} - The ID of the account that owns the resource.
Logical operators are \code{EQUALS} \\| \code{NOT_EQUALS}.
}}
}
\description{
Lists all license usage records for a license configuration, displaying
license consumption details by resource at a selected point in time. Use
this action to audit the current license consumption for any license
inventory and configuration.
}
\section{Request syntax}{
\preformatted{svc$list_usage_for_license_configuration(
  LicenseConfigurationArn = "string",
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
