% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_describe_effective_policy}
\alias{organizations_describe_effective_policy}
\title{Returns the contents of the effective tag policy for the account}
\usage{
organizations_describe_effective_policy(PolicyType, TargetId)
}
\arguments{
\item{PolicyType}{[required] The type of policy that you want information about.}

\item{TargetId}{When you\'re signed in as the master account, specify the ID of the
account that you want details about. Specifying an organization root or
OU as the target is not supported.}
}
\description{
Returns the contents of the effective tag policy for the account. The
effective tag policy is the aggregation of any tag policies the account
inherits, plus any policy directly that is attached to the account.
}
\details{
This action returns information on tag policies only.

For more information on policy inheritance, see \href{http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies-inheritance.html}{How Policy Inheritance Works}
in the \emph{AWS Organizations User Guide}.

This operation can be called from any account in the organization.
}
\section{Request syntax}{
\preformatted{svc$describe_effective_policy(
  PolicyType = "TAG_POLICY",
  TargetId = "string"
)
}
}

\keyword{internal}
