% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_create_backup}
\alias{opsworkscm_create_backup}
\title{Creates an application-level backup of a server}
\usage{
opsworkscm_create_backup(ServerName, Description, Tags)
}
\arguments{
\item{ServerName}{[required] The name of the server that you want to back up.}

\item{Description}{A user-defined description of the backup.}

\item{Tags}{A map that contains tag keys and tag values to attach to an AWS
OpsWorks-CM server backup.
\itemize{
\item The key cannot be empty.
\item The key can be a maximum of 127 characters, and can contain only
Unicode letters, numbers, or separators, or the following special
characters: \verb{+ - = . _ : /}
\item The value can be a maximum 255 characters, and contain only Unicode
letters, numbers, or separators, or the following special
characters: \verb{+ - = . _ : /}
\item Leading and trailing white spaces are trimmed from both the key and
value.
\item A maximum of 50 user-applied tags is allowed for tag-supported AWS
OpsWorks-CM resources.
}}
}
\description{
Creates an application-level backup of a server. While the server is in
the \code{BACKING_UP} state, the server cannot be changed, and no additional
backup can be created.
}
\details{
Backups can be created for servers in \code{RUNNING}, \code{HEALTHY}, and
\code{UNHEALTHY} states. By default, you can create a maximum of 50 manual
backups.

This operation is asynchronous.

A \code{LimitExceededException} is thrown when the maximum number of manual
backups is reached. An \code{InvalidStateException} is thrown when the server
is not in any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A
\code{ResourceNotFoundException} is thrown when the server is not found. A
\code{ValidationException} is thrown when parameters of the request are not
valid.
}
\section{Request syntax}{
\preformatted{svc$create_backup(
  ServerName = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
