# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchrum_service.R
NULL

#' Creates a Amazon CloudWatch RUM app monitor, which collects telemetry
#' data from your application and sends that data to RUM
#'
#' @description
#' Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/create_app_monitor.html](https://paws-r.github.io/docs/cloudwatchrum/create_app_monitor.html) for full documentation.
#'
#' @param AppMonitorConfiguration A structure that contains much of the configuration data for the app
#' monitor. If you are using Amazon Cognito for authorization, you must
#' include this structure in your request, and it must include the ID of
#' the Amazon Cognito identity pool to use for authorization. If you don't
#' include `AppMonitorConfiguration`, you must set up your own
#' authorization method. For more information, see Authorize your
#' application to send data to Amazon Web Services.
#' 
#' If you omit this argument, the sample rate used for RUM is set to 10% of
#' the user sessions.
#' @param CwLogEnabled Data collected by RUM is kept by RUM for 30 days and then deleted. This
#' parameter specifies whether RUM sends a copy of this telemetry data to
#' Amazon CloudWatch Logs in your account. This enables you to keep the
#' telemetry data for more than 30 days, but it does incur Amazon
#' CloudWatch Logs charges.
#' 
#' If you omit this parameter, the default is `false`.
#' @param Domain &#91;required&#93; The top-level internet domain name for which your application has
#' administrative authority.
#' @param Name &#91;required&#93; A name for the app monitor.
#' @param Tags Assigns one or more tags (key-value pairs) to the app monitor.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions by granting a user permission to
#' access or change only resources with certain tag values.
#' 
#' Tags don't have any semantic meaning to Amazon Web Services and are
#' interpreted strictly as strings of characters.
#' 
#'      <p>You can associate as many as 50 tags with an app monitor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p> 
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_create_app_monitor
cloudwatchrum_create_app_monitor <- function(AppMonitorConfiguration = NULL, CwLogEnabled = NULL, Domain, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateAppMonitor",
    http_method = "POST",
    http_path = "/appmonitor",
    paginator = list()
  )
  input <- .cloudwatchrum$create_app_monitor_input(AppMonitorConfiguration = AppMonitorConfiguration, CwLogEnabled = CwLogEnabled, Domain = Domain, Name = Name, Tags = Tags)
  output <- .cloudwatchrum$create_app_monitor_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$create_app_monitor <- cloudwatchrum_create_app_monitor

#' Deletes an existing app monitor
#'
#' @description
#' Deletes an existing app monitor. This immediately stops the collection of data.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/delete_app_monitor.html](https://paws-r.github.io/docs/cloudwatchrum/delete_app_monitor.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the app monitor to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_delete_app_monitor
cloudwatchrum_delete_app_monitor <- function(Name) {
  op <- new_operation(
    name = "DeleteAppMonitor",
    http_method = "DELETE",
    http_path = "/appmonitor/{Name}",
    paginator = list()
  )
  input <- .cloudwatchrum$delete_app_monitor_input(Name = Name)
  output <- .cloudwatchrum$delete_app_monitor_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$delete_app_monitor <- cloudwatchrum_delete_app_monitor

#' Retrieves the complete configuration information for one app monitor
#'
#' @description
#' Retrieves the complete configuration information for one app monitor.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/get_app_monitor.html](https://paws-r.github.io/docs/cloudwatchrum/get_app_monitor.html) for full documentation.
#'
#' @param Name &#91;required&#93; The app monitor to retrieve information for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_get_app_monitor
cloudwatchrum_get_app_monitor <- function(Name) {
  op <- new_operation(
    name = "GetAppMonitor",
    http_method = "GET",
    http_path = "/appmonitor/{Name}",
    paginator = list()
  )
  input <- .cloudwatchrum$get_app_monitor_input(Name = Name)
  output <- .cloudwatchrum$get_app_monitor_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$get_app_monitor <- cloudwatchrum_get_app_monitor

#' Retrieves the raw performance events that RUM has collected from your
#' web application, so that you can do your own processing or analysis of
#' this data
#'
#' @description
#' Retrieves the raw performance events that RUM has collected from your web application, so that you can do your own processing or analysis of this data.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/get_app_monitor_data.html](https://paws-r.github.io/docs/cloudwatchrum/get_app_monitor_data.html) for full documentation.
#'
#' @param Filters An array of structures that you can use to filter the results to those
#' that match one or more sets of key-value pairs that you specify.
#' @param MaxResults The maximum number of results to return in one operation.
#' @param Name &#91;required&#93; The name of the app monitor that collected the data that you want to
#' retrieve.
#' @param NextToken Use the token returned by the previous operation to request the next
#' page of results.
#' @param TimeRange &#91;required&#93; A structure that defines the time range that you want to retrieve
#' results from.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_get_app_monitor_data
cloudwatchrum_get_app_monitor_data <- function(Filters = NULL, MaxResults = NULL, Name, NextToken = NULL, TimeRange) {
  op <- new_operation(
    name = "GetAppMonitorData",
    http_method = "POST",
    http_path = "/appmonitor/{Name}/data",
    paginator = list()
  )
  input <- .cloudwatchrum$get_app_monitor_data_input(Filters = Filters, MaxResults = MaxResults, Name = Name, NextToken = NextToken, TimeRange = TimeRange)
  output <- .cloudwatchrum$get_app_monitor_data_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$get_app_monitor_data <- cloudwatchrum_get_app_monitor_data

#' Returns a list of the Amazon CloudWatch RUM app monitors in the account
#'
#' @description
#' Returns a list of the Amazon CloudWatch RUM app monitors in the account.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/list_app_monitors.html](https://paws-r.github.io/docs/cloudwatchrum/list_app_monitors.html) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in one operation.
#' @param NextToken Use the token returned by the previous operation to request the next
#' page of results.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_list_app_monitors
cloudwatchrum_list_app_monitors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAppMonitors",
    http_method = "POST",
    http_path = "/appmonitors",
    paginator = list()
  )
  input <- .cloudwatchrum$list_app_monitors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudwatchrum$list_app_monitors_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$list_app_monitors <- cloudwatchrum_list_app_monitors

#' Displays the tags associated with a CloudWatch RUM resource
#'
#' @description
#' Displays the tags associated with a CloudWatch RUM resource.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/list_tags_for_resource.html](https://paws-r.github.io/docs/cloudwatchrum/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource that you want to see the tags of.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_list_tags_for_resource
cloudwatchrum_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .cloudwatchrum$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cloudwatchrum$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$list_tags_for_resource <- cloudwatchrum_list_tags_for_resource

#' Sends telemetry events about your application performance and user
#' behavior to CloudWatch RUM
#'
#' @description
#' Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code snippet that RUM generates for you to add to your application includes [`put_rum_events`][cloudwatchrum_put_rum_events] operations to send this data to RUM.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/put_rum_events.html](https://paws-r.github.io/docs/cloudwatchrum/put_rum_events.html) for full documentation.
#'
#' @param AppMonitorDetails &#91;required&#93; A structure that contains information about the app monitor that
#' collected this telemetry information.
#' @param BatchId &#91;required&#93; A unique identifier for this batch of RUM event data.
#' @param Id &#91;required&#93; The ID of the app monitor that is sending this data.
#' @param RumEvents &#91;required&#93; An array of structures that contain the telemetry event data.
#' @param UserDetails &#91;required&#93; A structure that contains information about the user session that this
#' batch of events was collected from.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_put_rum_events
cloudwatchrum_put_rum_events <- function(AppMonitorDetails, BatchId, Id, RumEvents, UserDetails) {
  op <- new_operation(
    name = "PutRumEvents",
    http_method = "POST",
    http_path = "/appmonitors/{Id}/",
    paginator = list()
  )
  input <- .cloudwatchrum$put_rum_events_input(AppMonitorDetails = AppMonitorDetails, BatchId = BatchId, Id = Id, RumEvents = RumEvents, UserDetails = UserDetails)
  output <- .cloudwatchrum$put_rum_events_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$put_rum_events <- cloudwatchrum_put_rum_events

#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' RUM resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently, the only resources that can be tagged app monitors.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/tag_resource.html](https://paws-r.github.io/docs/cloudwatchrum/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the CloudWatch RUM resource that you're adding tags to.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_tag_resource
cloudwatchrum_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .cloudwatchrum$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .cloudwatchrum$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$tag_resource <- cloudwatchrum_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/untag_resource.html](https://paws-r.github.io/docs/cloudwatchrum/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the CloudWatch RUM resource that you're removing tags from.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_untag_resource
cloudwatchrum_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .cloudwatchrum$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .cloudwatchrum$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$untag_resource <- cloudwatchrum_untag_resource

#' Updates the configuration of an existing app monitor
#'
#' @description
#' Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor configuration that you specify in this operation are changed. For any parameters that you omit, the existing values are kept.
#'
#' See [https://paws-r.github.io/docs/cloudwatchrum/update_app_monitor.html](https://paws-r.github.io/docs/cloudwatchrum/update_app_monitor.html) for full documentation.
#'
#' @param AppMonitorConfiguration A structure that contains much of the configuration data for the app
#' monitor. If you are using Amazon Cognito for authorization, you must
#' include this structure in your request, and it must include the ID of
#' the Amazon Cognito identity pool to use for authorization. If you don't
#' include `AppMonitorConfiguration`, you must set up your own
#' authorization method. For more information, see Authorize your
#' application to send data to Amazon Web Services.
#' @param CwLogEnabled Data collected by RUM is kept by RUM for 30 days and then deleted. This
#' parameter specifies whether RUM sends a copy of this telemetry data to
#' Amazon CloudWatch Logs in your account. This enables you to keep the
#' telemetry data for more than 30 days, but it does incur Amazon
#' CloudWatch Logs charges.
#' @param Domain The top-level internet domain name for which your application has
#' administrative authority.
#' @param Name &#91;required&#93; The name of the app monitor to update.
#'
#' @keywords internal
#'
#' @rdname cloudwatchrum_update_app_monitor
cloudwatchrum_update_app_monitor <- function(AppMonitorConfiguration = NULL, CwLogEnabled = NULL, Domain = NULL, Name) {
  op <- new_operation(
    name = "UpdateAppMonitor",
    http_method = "PATCH",
    http_path = "/appmonitor/{Name}",
    paginator = list()
  )
  input <- .cloudwatchrum$update_app_monitor_input(AppMonitorConfiguration = AppMonitorConfiguration, CwLogEnabled = CwLogEnabled, Domain = Domain, Name = Name)
  output <- .cloudwatchrum$update_app_monitor_output()
  config <- get_config()
  svc <- .cloudwatchrum$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchrum$operations$update_app_monitor <- cloudwatchrum_update_app_monitor
