% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_affected_accounts_for_organization}
\alias{health_describe_affected_accounts_for_organization}
\title{Returns a list of accounts in the organization from Organizations that
are affected by the provided event}
\usage{
health_describe_affected_accounts_for_organization(
  eventArn,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{eventArn}{[required] The unique identifier for the event. The event ARN has the
\code{arn:aws:health:event-region::event/SERVICE/EVENT_TYPE_CODE/EVENT_TYPE_PLUS_ID }
format.

For example, an event ARN might look like the following:

\verb{arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456}}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}
}
\description{
Returns a list of accounts in the organization from Organizations that are affected by the provided event. For more information about the different types of Health events, see \href{https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html}{Event}.

See \url{https://paws-r.github.io/docs/health/describe_affected_accounts_for_organization.html} for full documentation.
}
\keyword{internal}
