% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_license}
\alias{licensemanager_create_license}
\title{Creates a license}
\usage{
licensemanager_create_license(
  LicenseName,
  ProductName,
  ProductSKU,
  Issuer,
  HomeRegion,
  Validity,
  Entitlements,
  Beneficiary,
  ConsumptionConfiguration,
  LicenseMetadata = NULL,
  ClientToken
)
}
\arguments{
\item{LicenseName}{[required] License name.}

\item{ProductName}{[required] Product name.}

\item{ProductSKU}{[required] Product SKU.}

\item{Issuer}{[required] License issuer.}

\item{HomeRegion}{[required] Home Region for the license.}

\item{Validity}{[required] Date and time range during which the license is valid, in ISO8601-UTC
format.}

\item{Entitlements}{[required] License entitlements.}

\item{Beneficiary}{[required] License beneficiary.}

\item{ConsumptionConfiguration}{[required] Configuration for consumption of the license. Choose a provisional
configuration for workloads running with continuous connectivity. Choose
a borrow configuration for workloads with offline usage.}

\item{LicenseMetadata}{Information about the license.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Creates a license.

See \url{https://paws-r.github.io/docs/licensemanager/create_license.html} for full documentation.
}
\keyword{internal}
