% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_stop_instance}
\alias{opsworks_stop_instance}
\title{Stops a specified instance}
\usage{
opsworks_stop_instance(InstanceId, Force = NULL)
}
\arguments{
\item{InstanceId}{[required] The instance ID.}

\item{Force}{Specifies whether to force an instance to stop. If the instance's root
device type is \code{ebs}, or EBS-backed, adding the \code{Force} parameter to the
\code{StopInstances} API call disassociates the AWS OpsWorks Stacks instance
from EC2, and forces deletion of \emph{only} the OpsWorks Stacks instance.
You must also delete the formerly-associated instance in EC2 after
troubleshooting and replacing the AWS OpsWorks Stacks instance with a
new one.}
}
\description{
Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html}{Starting, Stopping, and Rebooting Instances}.

See \url{https://paws-r.github.io/docs/opsworks/stop_instance.html} for full documentation.
}
\keyword{internal}
