% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_create_resiliency_policy}
\alias{resiliencehub_create_resiliency_policy}
\title{Creates a resiliency policy for an application}
\usage{
resiliencehub_create_resiliency_policy(
  clientToken = NULL,
  dataLocationConstraint = NULL,
  policy,
  policyDescription = NULL,
  policyName,
  tags = NULL,
  tier
)
}
\arguments{
\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{dataLocationConstraint}{Specifies a high-level geographical location constraint for where your
resilience policy data can be stored.}

\item{policy}{[required] The type of resiliency policy to be created, including the recovery time
objective (RTO) and recovery point objective (RPO) in seconds.}

\item{policyDescription}{The description for the policy.}

\item{policyName}{[required] The name of the policy}

\item{tags}{The tags assigned to the resource. A tag is a label that you assign to
an Amazon Web Services resource. Each tag consists of a key/value pair.}

\item{tier}{[required] The tier for this resiliency policy, ranging from the highest severity
(\code{MissionCritical}) to lowest (\code{NonCritical}).}
}
\description{
Creates a resiliency policy for an application.

See \url{https://paws-r.github.io/docs/resiliencehub/create_resiliency_policy.html} for full documentation.
}
\keyword{internal}
