% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_describe_app_version_resources_resolution_status}
\alias{resiliencehub_describe_app_version_resources_resolution_status}
\title{Returns the resolution status for the specified resolution identifier
for an application version}
\usage{
resiliencehub_describe_app_version_resources_resolution_status(
  appArn,
  appVersion,
  resolutionId = NULL
)
}
\arguments{
\item{appArn}{[required] The Amazon Resource Name (ARN) of the application. The format for this
ARN is: arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference}.}

\item{appVersion}{[required] The version of the application.}

\item{resolutionId}{The identifier for a specific resolution.}
}
\description{
Returns the resolution status for the specified resolution identifier for an application version. If \code{resolutionId} is not specified, the current resolution status is returned.

See \url{https://paws-r.github.io/docs/resiliencehub/describe_app_version_resources_resolution_status.html} for full documentation.
}
\keyword{internal}
