% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_execute_change_set}
\alias{cloudformation_execute_change_set}
\title{Updates a stack using the input information that was provided when the
specified change set was created}
\usage{
cloudformation_execute_change_set(
  ChangeSetName,
  StackName = NULL,
  ClientRequestToken = NULL,
  DisableRollback = NULL
)
}
\arguments{
\item{ChangeSetName}{[required] The name or Amazon Resource Name (ARN) of the change set that you want
use to update the specified stack.}

\item{StackName}{If you specified the name of a change set, specify the stack name or
Amazon Resource Name (ARN) that's associated with the change set you
want to execute.}

\item{ClientRequestToken}{A unique identifier for this
\code{\link[=cloudformation_execute_change_set]{execute_change_set}} request.
Specify this token if you plan to retry requests so that CloudFormation
knows that you're not attempting to execute a change set to update a
stack with the same name. You might retry
\code{\link[=cloudformation_execute_change_set]{execute_change_set}} requests to
ensure that CloudFormation successfully received them.}

\item{DisableRollback}{Preserves the state of previously provisioned resources when an
operation fails.

Default: \code{True}}
}
\description{
Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the \code{\link[=cloudformation_describe_stacks]{describe_stacks}} action to view the status of the update.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_execute_change_set/} for full documentation.
}
\keyword{internal}
