% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_service.R
\name{licensemanager}
\alias{licensemanager}
\title{AWS License Manager}
\usage{
licensemanager(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
License Manager makes it easier to manage licenses from software vendors
across multiple Amazon Web Services accounts and on-premises servers.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- licensemanager(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=licensemanager_accept_grant]{accept_grant} \tab Accepts the specified grant\cr
\link[=licensemanager_check_in_license]{check_in_license} \tab Checks in the specified license\cr
\link[=licensemanager_checkout_borrow_license]{checkout_borrow_license} \tab Checks out the specified license for offline use\cr
\link[=licensemanager_checkout_license]{checkout_license} \tab Checks out the specified license\cr
\link[=licensemanager_create_grant]{create_grant} \tab Creates a grant for the specified license\cr
\link[=licensemanager_create_grant_version]{create_grant_version} \tab Creates a new version of the specified grant\cr
\link[=licensemanager_create_license]{create_license} \tab Creates a license\cr
\link[=licensemanager_create_license_configuration]{create_license_configuration} \tab Creates a license configuration\cr
\link[=licensemanager_create_license_conversion_task_for_resource]{create_license_conversion_task_for_resource} \tab Creates a new license conversion task\cr
\link[=licensemanager_create_license_manager_report_generator]{create_license_manager_report_generator} \tab Creates a report generator\cr
\link[=licensemanager_create_license_version]{create_license_version} \tab Creates a new version of the specified license\cr
\link[=licensemanager_create_token]{create_token} \tab Creates a long-lived token\cr
\link[=licensemanager_delete_grant]{delete_grant} \tab Deletes the specified grant\cr
\link[=licensemanager_delete_license]{delete_license} \tab Deletes the specified license\cr
\link[=licensemanager_delete_license_configuration]{delete_license_configuration} \tab Deletes the specified license configuration\cr
\link[=licensemanager_delete_license_manager_report_generator]{delete_license_manager_report_generator} \tab Deletes the specified report generator\cr
\link[=licensemanager_delete_token]{delete_token} \tab Deletes the specified token\cr
\link[=licensemanager_extend_license_consumption]{extend_license_consumption} \tab Extends the expiration date for license consumption\cr
\link[=licensemanager_get_access_token]{get_access_token} \tab Gets a temporary access token to use with AssumeRoleWithWebIdentity\cr
\link[=licensemanager_get_grant]{get_grant} \tab Gets detailed information about the specified grant\cr
\link[=licensemanager_get_license]{get_license} \tab Gets detailed information about the specified license\cr
\link[=licensemanager_get_license_configuration]{get_license_configuration} \tab Gets detailed information about the specified license configuration\cr
\link[=licensemanager_get_license_conversion_task]{get_license_conversion_task} \tab Gets information about the specified license type conversion task\cr
\link[=licensemanager_get_license_manager_report_generator]{get_license_manager_report_generator} \tab Gets information about the specified report generator\cr
\link[=licensemanager_get_license_usage]{get_license_usage} \tab Gets detailed information about the usage of the specified license\cr
\link[=licensemanager_get_service_settings]{get_service_settings} \tab Gets the License Manager settings for the current Region\cr
\link[=licensemanager_list_associations_for_license_configuration]{list_associations_for_license_configuration} \tab Lists the resource associations for the specified license configuration\cr
\link[=licensemanager_list_distributed_grants]{list_distributed_grants} \tab Lists the grants distributed for the specified license\cr
\link[=licensemanager_list_failures_for_license_configuration_operations]{list_failures_for_license_configuration_operations} \tab Lists the license configuration operations that failed\cr
\link[=licensemanager_list_license_configurations]{list_license_configurations} \tab Lists the license configurations for your account\cr
\link[=licensemanager_list_license_conversion_tasks]{list_license_conversion_tasks} \tab Lists the license type conversion tasks for your account\cr
\link[=licensemanager_list_license_manager_report_generators]{list_license_manager_report_generators} \tab Lists the report generators for your account\cr
\link[=licensemanager_list_licenses]{list_licenses} \tab Lists the licenses for your account\cr
\link[=licensemanager_list_license_specifications_for_resource]{list_license_specifications_for_resource} \tab Describes the license configurations for the specified resource\cr
\link[=licensemanager_list_license_versions]{list_license_versions} \tab Lists all versions of the specified license\cr
\link[=licensemanager_list_received_grants]{list_received_grants} \tab Lists grants that are received\cr
\link[=licensemanager_list_received_grants_for_organization]{list_received_grants_for_organization} \tab Lists the grants received for all accounts in the organization\cr
\link[=licensemanager_list_received_licenses]{list_received_licenses} \tab Lists received licenses\cr
\link[=licensemanager_list_received_licenses_for_organization]{list_received_licenses_for_organization} \tab Lists the licenses received for all accounts in the organization\cr
\link[=licensemanager_list_resource_inventory]{list_resource_inventory} \tab Lists resources managed using Systems Manager inventory\cr
\link[=licensemanager_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for the specified license configuration\cr
\link[=licensemanager_list_tokens]{list_tokens} \tab Lists your tokens\cr
\link[=licensemanager_list_usage_for_license_configuration]{list_usage_for_license_configuration} \tab Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time\cr
\link[=licensemanager_reject_grant]{reject_grant} \tab Rejects the specified grant\cr
\link[=licensemanager_tag_resource]{tag_resource} \tab Adds the specified tags to the specified license configuration\cr
\link[=licensemanager_untag_resource]{untag_resource} \tab Removes the specified tags from the specified license configuration\cr
\link[=licensemanager_update_license_configuration]{update_license_configuration} \tab Modifies the attributes of an existing license configuration\cr
\link[=licensemanager_update_license_manager_report_generator]{update_license_manager_report_generator} \tab Updates a report generator\cr
\link[=licensemanager_update_license_specifications_for_resource]{update_license_specifications_for_resource} \tab Adds or removes the specified license configurations for the specified Amazon Web Services resource\cr
\link[=licensemanager_update_service_settings]{update_service_settings} \tab Updates License Manager settings for the current Region
}
}

\examples{
\dontrun{
svc <- licensemanager()
svc$accept_grant(
  Foo = 123
)
}

}
