% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_create_recommendation_template}
\alias{resiliencehub_create_recommendation_template}
\title{Creates a new recommendation template for the Resilience Hub application}
\usage{
resiliencehub_create_recommendation_template(
  assessmentArn,
  bucketName = NULL,
  clientToken = NULL,
  format = NULL,
  name,
  recommendationIds = NULL,
  recommendationTypes = NULL,
  tags = NULL
)
}
\arguments{
\item{assessmentArn}{[required] The Amazon Resource Name (ARN) of the assessment. The format for this
ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app-assessment/\code{app-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference} guide.}

\item{bucketName}{The name of the Amazon S3 bucket that will contain the recommendation
template.}

\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{format}{The format for the recommendation template.

\strong{CfnJson}

The template is CloudFormation JSON.

\strong{CfnYaml}

The template is CloudFormation YAML.}

\item{name}{[required] The name for the recommendation template.}

\item{recommendationIds}{Identifiers for the recommendations used to create a recommendation
template.}

\item{recommendationTypes}{An array of strings that specify the recommendation template type or
types.

\strong{Alarm}

The template is an AlarmRecommendation template.

\strong{Sop}

The template is a SopRecommendation template.

\strong{Test}

The template is a TestRecommendation template.}

\item{tags}{The tags assigned to the resource. A tag is a label that you assign to
an Amazon Web Services resource. Each tag consists of a key/value pair.}
}
\description{
Creates a new recommendation template for the Resilience Hub application.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_create_recommendation_template/} for full documentation.
}
\keyword{internal}
